/*
 * Decompiled with CFR 0.152.
 */
package a.simpleMustangGui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.io.RandomAccessReadBufferedFile;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.mustangproject.ZUGFeRD.ZUGFeRDImporter;
import org.mustangproject.validator.ZUGFeRDValidator;

public class SimpleMustangGui
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String lang = Locale.getDefault().getLanguage();
    private static final String lang_de = Locale.GERMAN.getLanguage();
    private static final SimpleDateFormat sdf_issue_date = new SimpleDateFormat("yyyyMMdd");
    private static final SimpleDateFormat sdf_issue_date_de = new SimpleDateFormat("dd.MM.yyyy");
    private File currentFile = null;
    private File openDirectory = null;
    private JMenuBar menubar;
    private JToolBar toolbar;
    private JLabel status;
    private JButton pdfPreviewButton;
    private JTextField searchTextField;
    private JDialog helphelpDialog;
    private JEditorPane textArea;
    private ComponentEnabler searchEnabler = new ComponentEnabler(false);
    private ComponentEnabler quickInfoEnabler = new ComponentEnabler(false);
    private ComponentEnabler validateEnabler = new ComponentEnabler(false);
    private PDDocument pdfDocument = null;
    private ZUGFeRDImporter zi = null;
    private byte[] xmlContent = null;
    private List<ImageIcon> pdfPreviewImageIconList = new ArrayList<ImageIcon>();
    private int currentPreviewImageIconIndex = -1;
    private static final int appSizeX = 1440;
    private static final int appSizeY = 810;
    private static final int helpSizeX = 640;
    private static final int helpSizeY = 360;
    private static final int defaultAppFontSize = 14;
    private static char cFile = (char)70;
    private static char cOpen = (char)79;
    private static char cExit = (char)120;
    private static char cHelp = (char)72;
    private static char cAbout = (char)65;
    private static char cValidate = (char)86;
    private static char cQuickInfo = (char)81;
    private static String sFile = "File";
    private static String sOpen = "Open";
    private static String sExit = "Exit";
    private static String sHelp = "Help";
    private static String sAbout = "About";
    private static String sValidate = "Validate";
    private static String sQuickInfo = "QuickInfo";
    private static String sTitle = "Simple Mustang GUI";
    private static String sHelpTitle = sTitle + " " + sHelp;
    private static String sAboutDialogText = sTitle + " v 1.0.1. (C) Copyright 2024, 2025 Alexander Adam";
    private static String sAboutDialogTitle = sAbout + " " + sTitle;
    private static String sTipOpen = "Open (PDF)";
    private static String sTipValidate = "Call ZUGFeRDValidator";
    private static String sTipQuickInfo = "Show QuickInfo";
    private static String sTipHelp = "Show help";
    private static String sTipPdfNextPage = "[click for next page ...]";
    private static String sInitialSearchText = "enter search text here (overwrite)";
    private static String sSearchButtonText = "Search >>> ";
    private static String sPDF = "PDF";
    private static String sTextXmlLine = "Text/XML Line";
    private static String sNoZugferdXml = "No ZUGFeRD XML found in PDF file.";
    private static String sHtmlHelpText = "<!DOCTYPE html><html><head><title>Help</title></head><body><h1>Help</h1>Simple tool to view and validate (ZUGFeRD) PDF files and show optional XML content.<p>If PDF has multiple pages, you can click on the current PDF page, to switch to the next page.<p>To <b>search</b> in XML, overwrite search input field with search text and press the [" + sSearchButtonText + "] button.<p>" + sQuickInfo + " gives values like BIC, IBAN, etc.<p>Note: The validation messages are subject to the Mustangproject method ZUGFeRDValidator.</body></html>";

    SimpleMustangGui() {
        super(true);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.toString());
        }
        this.setLayout(new BorderLayout());
        this.textArea = new JEditorPane();
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Monospaced", 0, 14));
        this.textArea.addCaretListener(new TextCaretListener());
        Font font = new Font(this.getFont().getFontName(), this.getFont().getStyle(), 14);
        this.setFont(font);
        JScrollPane scrollPaneMessageArea = new JScrollPane(this.textArea);
        this.menubar = this.createMenubar();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("North", this.createToolbar());
        panel.add("Center", scrollPaneMessageArea);
        panel.add("West", this.createPdfPreview());
        this.add("North", this.menubar);
        this.add("Center", panel);
        this.add("South", this.createStatusbar());
    }

    public static void main(String[] args) {
        try {
            if (lang_de.equals(lang)) {
                cFile = (char)68;
                cOpen = (char)214;
                cExit = (char)66;
                cHelp = (char)72;
                cAbout = (char)80;
                cValidate = (char)220;
                cQuickInfo = (char)75;
                sFile = "Datei";
                sOpen = "\u00d6ffnen";
                sExit = "Beenden";
                sHelp = "Hilfe";
                sAbout = "Programminfo";
                sValidate = "\u00dcberpr\u00fcfung";
                sQuickInfo = "KurzInfo";
                sTitle = "Simple Mustang GUI";
                sHelpTitle = sTitle + " " + sHelp;
                sAboutDialogText = sTitle + ". (C) Copyright 2024, 2025 Alexander Adam";
                sAboutDialogTitle = sAbout + " " + sTitle;
                sTipOpen = "PDF-Datei \u00f6ffnen";
                sTipValidate = "ZUGFeRDValidator Pr\u00fcfung";
                sTipQuickInfo = "KurzInfos anzeigen";
                sTipHelp = "Hilfe anzeigen";
                sTipPdfNextPage = "[Dr\u00fccken f\u00fcr nexte Seite ...]";
                sInitialSearchText = "Suchtext hier eingeben (\u00fcberschreiben)";
                sSearchButtonText = "Suchen >>> ";
                sPDF = "PDF";
                sTextXmlLine = "Text/XML Zeile";
                sNoZugferdXml = "No ZUGFeRD XML found in PDF file.";
                sHtmlHelpText = "<!DOCTYPE html><html><head><title>Hilfe</title></head><body><h1>Hilfe</h1>Ein einfach gehaltenes Programm zur Ansicht und \u00dcberpr\u00fcfung von (ZUGFeRD) PDF-Dateien.<br>Sofern vorhanden, zeigt das Programm auch die XML Daten aus der PDF-Datei.<p>Besteht die <b>PDF-Datei aus mehreren Seiten</b>, kann man mittels Maus-Click weiter bl\u00e4ttern.<p>Zur einfachen <b>Text-Suche</b> in den XML Daten, den Suchtext in das Suchfeld eingeben und die Suche mittels [" + sSearchButtonText + "] starten.<p>Mit " + sQuickInfo + " werden Werte wie BIC, IBAN usw. angezeigt.<p>Hinweis: Die Meldungen der \u00dcberpr\u00fcfung unterliegen der Mustangproject Methode ZUGFeRDValidator.</body></html>";
            }
            JFrame frame = new JFrame();
            SimpleMustangGui appPane = new SimpleMustangGui();
            URL urlAppPaneIcon = appPane.getClass().getResource("/simpleMustangGui.png");
            if (urlAppPaneIcon != null) {
                frame.setIconImage(Toolkit.getDefaultToolkit().getImage(urlAppPaneIcon));
            }
            Font font = new Font(appPane.getFont().getFontName(), appPane.getFont().getStyle(), 14);
            frame.setFont(font);
            frame.setTitle(sTitle);
            frame.setBackground(Color.lightGray);
            frame.getContentPane().setLayout(new BorderLayout());
            frame.getContentPane().add("Center", appPane);
            frame.addWindowListener(new AppWindowAdapter());
            frame.pack();
            frame.setSize(1440, 810);
            frame.setVisible(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.toString());
        }
    }

    private static void Close() {
        System.exit(0);
    }

    private Frame getTopFrame() {
        for (Container p = this.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof Frame)) continue;
            return (Frame)p;
        }
        return null;
    }

    private JMenuBar createMenubar() {
        JMenuBar mb = new JMenuBar();
        JMenu menuFile = new JMenu(sFile);
        JMenuItem itemFileOpen = new JMenuItem(sOpen, cOpen);
        JMenuItem itemFileQuickInfo = new JMenuItem(sQuickInfo, cQuickInfo);
        JMenuItem itemFileValidate = new JMenuItem(sValidate, cValidate);
        JMenuItem itemFileExit = new JMenuItem(sExit, cExit);
        JMenu menuHelp = new JMenu(sHelp);
        JMenuItem itemHelpHelp = new JMenuItem(sHelp, cHelp);
        JMenuItem itemHelpAbout = new JMenuItem(sAbout, cAbout);
        menuFile.setMnemonic(cFile);
        menuHelp.setMnemonic(cHelp);
        itemFileOpen.setToolTipText(sTipOpen);
        itemFileQuickInfo.setToolTipText(sTipQuickInfo);
        itemFileValidate.setToolTipText(sTipValidate);
        itemHelpHelp.setToolTipText(sTipHelp);
        itemFileOpen.addActionListener(new FileOpenListener());
        itemFileValidate.addActionListener(new ZUGFeRDValidationListener());
        itemFileQuickInfo.addActionListener(new QuickInfoListener());
        itemFileExit.addActionListener(new FileExitListener());
        itemHelpHelp.addActionListener(new HelpHelpListener());
        itemHelpAbout.addActionListener(new HelpAboutListener());
        this.validateEnabler.add(itemFileValidate);
        this.validateEnabler.update();
        this.quickInfoEnabler.add(itemFileQuickInfo);
        this.quickInfoEnabler.update();
        menuFile.add(itemFileOpen);
        menuFile.add(itemFileQuickInfo);
        menuFile.add(itemFileValidate);
        menuFile.addSeparator();
        menuFile.add(itemFileExit);
        menuHelp.add(itemHelpHelp);
        menuHelp.add(itemHelpAbout);
        mb.add(menuFile);
        mb.add(menuHelp);
        return mb;
    }

    private Component createToolbar() {
        this.toolbar = new JToolBar();
        this.searchTextField = new JTextField(sInitialSearchText);
        JButton searchButton = new JButton(sSearchButtonText);
        searchButton.addActionListener(new SearchListener());
        JButton tbuttonOpen = new JButton(sOpen);
        tbuttonOpen.setToolTipText(sTipOpen);
        tbuttonOpen.addActionListener(new FileOpenListener());
        this.searchEnabler.add(searchButton);
        this.searchEnabler.add(this.searchTextField);
        this.searchEnabler.update();
        this.toolbar.add(tbuttonOpen);
        this.toolbar.addSeparator();
        this.toolbar.add(searchButton);
        this.toolbar.add(this.searchTextField);
        return this.toolbar;
    }

    private JLabel createStatusbar() {
        this.status = new JLabel();
        return this.status;
    }

    private JButton createPdfPreview() {
        this.pdfPreviewButton = new JButton(sPDF, null);
        this.pdfPreviewButton.addActionListener(new PreviewButtonActionListener());
        return this.pdfPreviewButton;
    }

    private void searchTextAndPositionCaret(JEditorPane editorPane, JTextField searchTextField) {
        try {
            int currentCaretPos = editorPane.getCaretPosition();
            int length = editorPane.getDocument().getLength();
            String searchText = searchTextField.getText();
            String docText = editorPane.getDocument().getText(0, length);
            String docTextRest = docText.substring(currentCaretPos);
            int spos = -1;
            int sposRest = docTextRest.indexOf(searchText);
            spos = sposRest != -1 ? currentCaretPos + sposRest : docText.indexOf(searchText);
            if (spos != -1) {
                editorPane.setCaretPosition(spos);
                editorPane.select(spos, spos + searchText.length());
                editorPane.grabFocus();
            }
        }
        catch (BadLocationException e1) {
            this.status.setText(e1.getMessage());
        }
    }

    private class ComponentEnabler
    extends Vector<Component> {
        private static final long serialVersionUID = 1L;
        private boolean enabled;

        ComponentEnabler(boolean enable) {
            this.enabled = enable;
        }

        void setEnabled(boolean enable) {
            this.enabled = enable;
            this.update();
        }

        void update() {
            for (int i = 0; i < this.elementCount; ++i) {
                ((Component)this.get(i)).setEnabled(this.enabled);
            }
        }
    }

    private class TextCaretListener
    implements CaretListener {
        private TextCaretListener() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            String text = SimpleMustangGui.this.textArea.getText().replace("\r\n", "\n").substring(0, e.getDot());
            int line = 1 + e.getDot() - text.replace("\n", "").length();
            if (SimpleMustangGui.this.currentFile != null) {
                SimpleMustangGui.this.status.setText(sFile + ": " + SimpleMustangGui.this.currentFile.getPath() + " " + sTextXmlLine + ": " + line);
            } else {
                SimpleMustangGui.this.status.setText(sTextXmlLine + ": " + line);
            }
        }
    }

    private static final class AppWindowAdapter
    extends WindowAdapter {
        private AppWindowAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SimpleMustangGui.Close();
        }

        @Override
        public void windowActivated(WindowEvent e) {
            e.getWindow().repaint();
        }
    }

    private class FileOpenListener
    implements ActionListener {
        private FileOpenListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Frame topFrame = SimpleMustangGui.this.getTopFrame();
            FileDialog fd = new FileDialog(topFrame, sOpen, 0);
            if (SimpleMustangGui.this.openDirectory == null) {
                SimpleMustangGui.this.openDirectory = new File(System.getProperty("user.dir"));
            }
            fd.setDirectory(SimpleMustangGui.this.openDirectory.getPath());
            fd.setFile("");
            fd.setMultipleMode(false);
            fd.setVisible(true);
            File[] files = fd.getFiles();
            if (files != null && files.length > 0) {
                File file = files[0];
                SimpleMustangGui.this.pdfPreviewImageIconList.clear();
                SimpleMustangGui.this.pdfPreviewButton.setToolTipText("");
                SimpleMustangGui.this.searchEnabler.setEnabled(false);
                SimpleMustangGui.this.quickInfoEnabler.setEnabled(false);
                SimpleMustangGui.this.validateEnabler.setEnabled(false);
                SimpleMustangGui.this.pdfDocument = null;
                SimpleMustangGui.this.zi = null;
                SimpleMustangGui.this.xmlContent = null;
                try {
                    SimpleMustangGui.this.pdfDocument = Loader.loadPDF(new RandomAccessReadBufferedFile(file.getPath()));
                    SimpleMustangGui.this.quickInfoEnabler.setEnabled(true);
                    PDFRenderer pdfRenderer = new PDFRenderer(SimpleMustangGui.this.pdfDocument);
                    for (int page = 0; page < SimpleMustangGui.this.pdfDocument.getNumberOfPages(); ++page) {
                        SimpleMustangGui.this.pdfPreviewImageIconList.add(new ImageIcon(pdfRenderer.renderImage(page)));
                    }
                    if (SimpleMustangGui.this.pdfPreviewImageIconList.size() > 0) {
                        SimpleMustangGui.this.currentPreviewImageIconIndex = 0;
                        SimpleMustangGui.this.pdfPreviewButton.setText("");
                        SimpleMustangGui.this.pdfPreviewButton.setIcon(SimpleMustangGui.this.pdfPreviewImageIconList.get(SimpleMustangGui.this.currentPreviewImageIconIndex));
                        if (SimpleMustangGui.this.pdfPreviewImageIconList.size() > 1) {
                            SimpleMustangGui.this.pdfPreviewButton.setToolTipText(sTipPdfNextPage);
                        }
                    } else {
                        SimpleMustangGui.this.pdfPreviewButton.setText(sPDF);
                        SimpleMustangGui.this.currentPreviewImageIconIndex = -1;
                    }
                    SimpleMustangGui.this.openDirectory = file.getParentFile();
                    SimpleMustangGui.this.zi = new ZUGFeRDImporter(file.getPath());
                    if (SimpleMustangGui.this.zi != null) {
                        SimpleMustangGui.this.xmlContent = SimpleMustangGui.this.zi.getRawXML();
                    }
                    if (SimpleMustangGui.this.xmlContent == null) {
                        SimpleMustangGui.this.textArea.setText("");
                        SimpleMustangGui.this.searchEnabler.setEnabled(false);
                        SimpleMustangGui.this.status.setText(sFile + ": " + file.getName() + ". " + sNoZugferdXml);
                    } else {
                        SimpleMustangGui.this.textArea.setText(new String(SimpleMustangGui.this.xmlContent));
                        SimpleMustangGui.this.searchEnabler.setEnabled(true);
                        SimpleMustangGui.this.validateEnabler.setEnabled(true);
                    }
                    SimpleMustangGui.this.currentFile = file;
                    SimpleMustangGui.this.textArea.setCaretPosition(0);
                }
                catch (IOException ex) {
                    SimpleMustangGui.this.textArea.setText("");
                    SimpleMustangGui.this.searchEnabler.setEnabled(false);
                    SimpleMustangGui.this.pdfPreviewButton.setIcon(null);
                    SimpleMustangGui.this.status.setText("File: " + file.getName() + ". PDFRenderer: " + ex.getMessage());
                }
            }
        }
    }

    private class ZUGFeRDValidationListener
    implements ActionListener {
        private ZUGFeRDValidationListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (null != SimpleMustangGui.this.currentFile && null != SimpleMustangGui.this.xmlContent) {
                ZUGFeRDValidator zfv = new ZUGFeRDValidator();
                String validationResult = zfv.validate(SimpleMustangGui.this.currentFile.getPath());
                SimpleMustangGui.this.textArea.setText(String.format("%s\n%s", new String(SimpleMustangGui.this.xmlContent), validationResult));
                int statusPos = validationResult.lastIndexOf("<summary status=");
                if (statusPos > 0) {
                    if (validationResult.substring(statusPos).startsWith("<summary status=\"invalid\"/>")) {
                        JOptionPane.showMessageDialog(null, "ZUGFeRDValidator XML summary: Status is invalid!");
                    }
                    if (validationResult.substring(statusPos).startsWith("<summary status=\"valid\"/>")) {
                        JOptionPane.showMessageDialog(null, "ZUGFeRDValidator XML summary: Status is valid!");
                    }
                }
            }
        }
    }

    private class QuickInfoListener
    implements ActionListener {
        private QuickInfoListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object quickInfo = "";
            if (null != SimpleMustangGui.this.pdfDocument) {
                PDDocumentInformation pdfDocumentInformation = SimpleMustangGui.this.pdfDocument.getDocumentInformation();
                quickInfo = (String)quickInfo + "PDF Version: " + SimpleMustangGui.this.pdfDocument.getVersion() + "\n";
                if (null != pdfDocumentInformation && null != pdfDocumentInformation.getCreator()) {
                    quickInfo = (String)quickInfo + "PDF Creator: " + pdfDocumentInformation.getCreator() + "\n";
                }
                quickInfo = (String)quickInfo + "\n";
            }
            if (null != SimpleMustangGui.this.zi) {
                if (SimpleMustangGui.this.zi.getRawXML() == null) {
                    quickInfo = (String)quickInfo + sNoZugferdXml;
                } else {
                    String sIssueDate = SimpleMustangGui.this.zi.getIssueDate();
                    Object sIBAN = SimpleMustangGui.this.zi.getIBAN();
                    if (sIBAN != null && !((String)sIBAN).equals(((String)sIBAN).replace(" ", ""))) {
                        sIBAN = (String)sIBAN + " (" + SimpleMustangGui.this.zi.getIBAN().replace(" ", "") + ")";
                    }
                    if (lang.equals(lang_de)) {
                        try {
                            Date issueDate = sdf_issue_date.parse(sIssueDate);
                            sIssueDate = sdf_issue_date_de.format(issueDate);
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                        quickInfo = (String)quickInfo + "BIC: " + SimpleMustangGui.this.zi.getBIC() + "\nIBAN: " + (String)sIBAN + "\nKontoinhaber: " + SimpleMustangGui.this.zi.getHolder() + "\nRechnungsnr: " + SimpleMustangGui.this.zi.getForeignReference() + "\nRechnungsdatum: " + sIssueDate + "\nF\u00e4lliger Betrag: " + SimpleMustangGui.this.zi.getAmount().replace('.', ',');
                    } else {
                        quickInfo = (String)quickInfo + "BIC: " + SimpleMustangGui.this.zi.getBIC() + "\nIBAN: " + (String)sIBAN + "\nHolder: " + SimpleMustangGui.this.zi.getHolder() + "\nForeignReference: " + SimpleMustangGui.this.zi.getForeignReference() + "\nIssueDate: " + sIssueDate + "\nAmount: " + SimpleMustangGui.this.zi.getAmount();
                    }
                }
                JTextArea infoTextArea = new JTextArea((String)quickInfo);
                JOptionPane.showMessageDialog(null, infoTextArea);
            }
        }
    }

    private class FileExitListener
    implements ActionListener {
        private FileExitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SimpleMustangGui.Close();
        }
    }

    private class HelpHelpListener
    implements ActionListener {
        private HelpHelpListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Frame frame = SimpleMustangGui.this.getTopFrame();
            if (SimpleMustangGui.this.helphelpDialog == null) {
                SimpleMustangGui.this.helphelpDialog = new JDialog(frame, sHelpTitle, false);
                HtmlHelpPanel htmlHelpPanel = new HtmlHelpPanel();
                SimpleMustangGui.this.helphelpDialog.getContentPane().add((Component)htmlHelpPanel, "Center");
                SimpleMustangGui.this.helphelpDialog.pack();
            }
            SimpleMustangGui.this.helphelpDialog.setSize(640, 360);
            SimpleMustangGui.this.helphelpDialog.setVisible(true);
        }
    }

    private class HelpAboutListener
    implements ActionListener {
        private HelpAboutListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(null, sAboutDialogText, sAboutDialogTitle, 1);
        }
    }

    private class SearchListener
    implements ActionListener {
        private SearchListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SimpleMustangGui.this.searchTextAndPositionCaret(SimpleMustangGui.this.textArea, SimpleMustangGui.this.searchTextField);
        }
    }

    private class PreviewButtonActionListener
    implements ActionListener {
        private PreviewButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SimpleMustangGui.this.pdfPreviewImageIconList.isEmpty()) {
                SimpleMustangGui.this.currentPreviewImageIconIndex = (SimpleMustangGui.this.currentPreviewImageIconIndex + 1) % SimpleMustangGui.this.pdfPreviewImageIconList.size();
                SimpleMustangGui.this.pdfPreviewButton.setIcon(SimpleMustangGui.this.pdfPreviewImageIconList.get(SimpleMustangGui.this.currentPreviewImageIconIndex));
            }
        }
    }

    public class HtmlHelpPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JEditorPane html;

        public HtmlHelpPanel() {
            String helpFile = "/SimpleMustangGui.html";
            if (lang.equals(lang_de)) {
                helpFile = "/SimpleMustangGui_de.html";
            }
            this.setLayout(new BorderLayout());
            try {
                URL urlHelpFile = this.getClass().getResource(helpFile);
                this.html = urlHelpFile != null ? new JEditorPane(urlHelpFile) : new JEditorPane("text/html", sHtmlHelpText);
                this.html.setEditable(false);
                JScrollPane scroller = new JScrollPane();
                JViewport vp = scroller.getViewport();
                vp.add(this.html);
                this.add((Component)scroller, "Center");
            }
            catch (MalformedURLException ex) {
                JOptionPane.showMessageDialog(null, ex.toString());
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, ex.toString());
            }
        }
    }
}

