/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.lang;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.ArrayHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class GenericReflection {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericReflection.class);
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final GenericReflection INSTANCE = new GenericReflection();

    private GenericReflection() {
    }

    public static <SRCTYPE, DSTTYPE> DSTTYPE uncheckedCast(@Nullable SRCTYPE SRCTYPE) {
        return (DSTTYPE)SRCTYPE;
    }

    @Nonnull
    public static <DATATYPE> Class<DATATYPE> getClassFromName(@Nonnull ClassLoader classLoader, @Nonnull String string) throws ClassNotFoundException {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        return (Class)GenericReflection.uncheckedCast(classLoader.loadClass(string));
    }

    @Nonnull
    public static <DATATYPE> Class<DATATYPE> getClassFromName(@Nonnull String string) throws ClassNotFoundException {
        return (Class)GenericReflection.uncheckedCast(Class.forName(string));
    }

    @Nullable
    public static <DATATYPE> Class<DATATYPE> getClassFromNameSafe(@Nonnull ClassLoader classLoader, @Nonnull String string) {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        try {
            return GenericReflection.getClassFromName(classLoader, string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Nullable
    public static <DATATYPE> Class<DATATYPE> getClassFromNameSafe(@Nonnull String string) {
        try {
            return GenericReflection.getClassFromName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Nonnull
    public static Class<?>[] getClassArray(Object ... objectArray) {
        if (ArrayHelper.isEmpty(objectArray)) {
            return EMPTY_CLASS_ARRAY;
        }
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        return classArray;
    }

    @Nullable
    public static <RETURNTYPE> RETURNTYPE invokeMethod(@Nonnull Object object, @Nonnull String string, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return GenericReflection.invokeMethod(object, string, GenericReflection.getClassArray(objectArray), objectArray);
    }

    @Nullable
    public static <RETURNTYPE> RETURNTYPE invokeMethod(@Nonnull Object object, @Nonnull String string, @Nullable Class<?>[] classArray, @Nullable Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = object.getClass().getDeclaredMethod(string, classArray);
        Object object2 = method.invoke(object, objectArray);
        return (RETURNTYPE)GenericReflection.uncheckedCast(object2);
    }

    @Nullable
    public static <RETURNTYPE> RETURNTYPE invokeStaticMethod(@Nonnull String string, @Nonnull String string2, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        return GenericReflection.invokeStaticMethod(GenericReflection.getClassFromName(string), string2, objectArray);
    }

    @Nullable
    public static <RETURNTYPE> RETURNTYPE invokeStaticMethod(@Nonnull Class<?> clazz, @Nonnull String string, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return GenericReflection.invokeStaticMethod(clazz, string, GenericReflection.getClassArray(objectArray), objectArray);
    }

    @Nullable
    public static <RETURNTYPE> RETURNTYPE invokeStaticMethod(@Nonnull String string, @Nonnull String string2, @Nullable Class<?>[] classArray, @Nullable Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        return GenericReflection.invokeStaticMethod(GenericReflection.getClassFromName(string), string2, classArray, objectArray);
    }

    @Nullable
    public static <RETURNTYPE> RETURNTYPE invokeStaticMethod(@Nonnull Class<?> clazz, @Nonnull String string, @Nullable Class<?>[] classArray, @Nullable Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = clazz.getDeclaredMethod(string, classArray);
        Object object = method.invoke(null, objectArray);
        return (RETURNTYPE)GenericReflection.uncheckedCast(object);
    }

    @Nonnull
    public static <DATATYPE> Constructor<DATATYPE> findConstructor(@Nonnull DATATYPE DATATYPE, Class<?> ... classArray) throws NoSuchMethodException {
        return (Constructor)GenericReflection.uncheckedCast(DATATYPE.getClass().getConstructor(classArray));
    }

    @Nonnull
    public static <DATATYPE> DATATYPE newInstance(@Nonnull DATATYPE DATATYPE) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, InstantiationException {
        return GenericReflection.findConstructor(DATATYPE, new Class[0]).newInstance(new Object[0]);
    }

    @Nullable
    public static <DATATYPE> DATATYPE newInstance(@Nullable Class<? extends DATATYPE> clazz) {
        if (clazz != null) {
            try {
                return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to instantiate " + clazz, exception);
            }
        }
        return null;
    }

    @Nullable
    public static <DATATYPE> DATATYPE newInstance(@Nonnull ClassLoader classLoader, @Nullable String string, @Nullable Class<? extends DATATYPE> clazz) {
        if (string != null && clazz != null) {
            try {
                return clazz.cast(GenericReflection.getClassFromName(classLoader, string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception exception) {
                LOGGER.error("Failed to instantiate '" + string + "'", exception);
            }
        }
        return null;
    }

    @Nullable
    public static <DATATYPE> DATATYPE newInstance(@Nullable String string, @Nullable Class<? extends DATATYPE> clazz) {
        if (string != null && clazz != null) {
            try {
                return clazz.cast(GenericReflection.getClassFromName(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception exception) {
                LOGGER.error("Failed to instantiate '" + string + "'", exception);
            }
        }
        return null;
    }

    @Nullable
    public static <DATATYPE> DATATYPE newInstance(@Nullable String string, @Nullable Class<? extends DATATYPE> clazz, @Nullable ClassLoader classLoader) {
        if (string != null && clazz != null && classLoader != null) {
            try {
                return clazz.cast(Class.forName(string, true, classLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception exception) {
                LOGGER.error("Failed to instantiate '" + string + "' with CL " + classLoader, exception);
            }
        }
        return null;
    }
}

