/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.domain;

import com.helger.commons.ValueEnforcer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@FunctionalInterface
public interface IHasDeletionDateTime {
    @Nullable
    public LocalDateTime getDeletionDateTime();

    default public boolean hasDeletionDateTime() {
        return this.getDeletionDateTime() != null;
    }

    @Nullable
    default public LocalDate getDeletionDate() {
        LocalDateTime localDateTime = this.getDeletionDateTime();
        return localDateTime == null ? null : localDateTime.toLocalDate();
    }

    @Nullable
    default public LocalTime getDeletionTime() {
        LocalDateTime localDateTime = this.getDeletionDateTime();
        return localDateTime == null ? null : localDateTime.toLocalTime();
    }

    default public boolean isDeletedAt(@Nonnull LocalDateTime localDateTime) {
        ValueEnforcer.notNull(localDateTime, "LocalDateTime");
        return this.hasDeletionDateTime() && this.getDeletionDateTime().compareTo(localDateTime) <= 0;
    }
}

