/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.ByteBufferInputStream;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.NonBlockingStringReader;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.jaxb.IJAXBUnmarshaller;
import com.helger.xml.sax.InputSourceFactory;
import com.helger.xml.serialize.read.SAXReaderFactory;
import com.helger.xml.serialize.read.SAXReaderSettings;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public interface IJAXBReader<JAXBTYPE> {
    public boolean isUseSchema();

    @Nullable
    default public JAXBTYPE read(@Nonnull InputSource inputSource) {
        return this.read(new SAXReaderSettings(), inputSource);
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull SAXReaderSettings sAXReaderSettings, @Nonnull InputSource inputSource) {
        ValueEnforcer.notNull(sAXReaderSettings, "Settings");
        ValueEnforcer.notNull(inputSource, "InputSource");
        XMLReader xMLReader = SAXReaderFactory.createXMLReader();
        sAXReaderSettings.applyToSAXReader(xMLReader);
        return this.read(new SAXSource(xMLReader, inputSource));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull InputStream inputStream) {
        ValueEnforcer.notNull(inputStream, "InputStream");
        CharsetHelper.InputStreamAndCharset inputStreamAndCharset = CharsetHelper.getInputStreamAndCharsetFromBOM(inputStream);
        if (inputStreamAndCharset.hasCharset()) {
            return this.read(StreamHelper.createReader(inputStreamAndCharset.getInputStream(), inputStreamAndCharset.getCharset()));
        }
        return this.read(InputSourceFactory.create(inputStreamAndCharset.getInputStream()));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull Reader reader) {
        ValueEnforcer.notNull(reader, "Reader");
        return this.read(InputSourceFactory.create(reader));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull File file) {
        ValueEnforcer.notNull(file, "File");
        return this.read(InputSourceFactory.create(file));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull Path path) {
        ValueEnforcer.notNull(path, "Path");
        return this.read(InputSourceFactory.create(path));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull(iReadableResource, "Resource");
        return this.read(InputSourceFactory.create(iReadableResource));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull IHasInputStream iHasInputStream) {
        ValueEnforcer.notNull(iHasInputStream, "Resource");
        return this.read(iHasInputStream.getInputStream());
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull byte[] byArray) {
        ValueEnforcer.notNull(byArray, "XML");
        return this.read(new NonBlockingByteArrayInputStream(byArray));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(byArray, "XML");
        return this.read(new NonBlockingByteArrayInputStream(byArray, n, n2));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull ByteBuffer byteBuffer) {
        ValueEnforcer.notNull(byteBuffer, "XML");
        return this.read(new ByteBufferInputStream(byteBuffer));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull String string) {
        ValueEnforcer.notNull(string, "XML");
        return this.read(new NonBlockingStringReader(string));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull char[] cArray) {
        ValueEnforcer.notNull(cArray, "XML");
        return this.read(new NonBlockingStringReader(cArray));
    }

    @Nullable
    public JAXBTYPE read(@Nonnull IJAXBUnmarshaller<JAXBTYPE> var1);

    @Nullable
    default public JAXBTYPE read(@Nonnull Source source) {
        ValueEnforcer.notNull(source, "Source");
        return this.read((Unmarshaller unmarshaller, Class<JAXBTYPE> clazz) -> unmarshaller.unmarshal(source, clazz));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull Node node) {
        ValueEnforcer.notNull(node, "Node");
        return this.read((Unmarshaller unmarshaller, Class<JAXBTYPE> clazz) -> unmarshaller.unmarshal(node, clazz));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull XMLStreamReader xMLStreamReader) {
        ValueEnforcer.notNull(xMLStreamReader, "Reader");
        return this.read((Unmarshaller unmarshaller, Class<JAXBTYPE> clazz) -> unmarshaller.unmarshal(xMLStreamReader, clazz));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull XMLEventReader xMLEventReader) {
        ValueEnforcer.notNull(xMLEventReader, "Reader");
        return this.read((Unmarshaller unmarshaller, Class<JAXBTYPE> clazz) -> unmarshaller.unmarshal(xMLEventReader, clazz));
    }
}

