/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ClassLoaderHelper;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.log.ConditionalLogger;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.annotation.XmlSchema;
import java.lang.ref.WeakReference;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
@MustImplementEqualsAndHashcode
public class JAXBContextCacheKey {
    private static final Logger LOGGER = LoggerFactory.getLogger(JAXBContextCacheKey.class);
    private final ICommonsList<Package> m_aPackages;
    private final WeakReference<ClassLoader> m_aClassLoader;
    private final ICommonsList<WeakReference<Class<?>>> m_aClasses;
    private final Map<String, ?> m_aProperties;
    private final String m_sEqualsHashCodeKey;

    @Deprecated(forRemoval=true, since="11.0.4")
    public JAXBContextCacheKey(@Nonnull Package package_, @Nullable ClassLoader classLoader) {
        this(new CommonsArrayList<Package>(package_), classLoader);
    }

    public JAXBContextCacheKey(@Nonnull ICommonsList<Package> iCommonsList, @Nullable ClassLoader classLoader) {
        ValueEnforcer.notEmptyNoNullValue(iCommonsList, "Packages");
        this.m_aPackages = (ICommonsList)iCommonsList.getClone();
        this.m_aClassLoader = new WeakReference<ClassLoader>(classLoader);
        this.m_aClasses = null;
        this.m_aProperties = null;
        this.m_sEqualsHashCodeKey = StringHelper.imploder().source(iCommonsList, Package::getName).separator(':').build();
        for (Package package_ : iCommonsList) {
            if (package_.getAnnotation(XmlSchema.class) != null || GenericReflection.getClassFromNameSafe(package_.getName() + ".ObjectFactory") != null) continue;
            LOGGER.warn("The package '" + package_.getName() + "' does not seem to be JAXB generated! Trying to create a JAXBContext anyway.");
        }
    }

    public JAXBContextCacheKey(@Nonnull ICommonsList<Class<?>> iCommonsList, @Nullable Map<String, ?> map) {
        ValueEnforcer.notEmptyNoNullValue(iCommonsList, "Classes");
        this.m_aPackages = null;
        this.m_aClassLoader = null;
        this.m_aClasses = new CommonsArrayList<WeakReference>(iCommonsList, WeakReference::new);
        this.m_aProperties = new CommonsHashMap(map);
        this.m_sEqualsHashCodeKey = StringHelper.imploder().source(iCommonsList, Class::getName).separator(':').build();
    }

    @Nullable
    @ReturnsMutableCopy
    private ICommonsList<Class<?>> _getAllClasses() {
        CommonsArrayList commonsArrayList = null;
        if (this.m_aClasses != null) {
            commonsArrayList = new CommonsArrayList();
            for (WeakReference weakReference : this.m_aClasses) {
                Class clazz = (Class)weakReference.get();
                if (clazz == null) continue;
                commonsArrayList.add(clazz);
            }
        }
        return commonsArrayList;
    }

    @Nullable
    private ClassLoader _getClassLoader() {
        ClassLoader classLoader = null;
        if (this.m_aClassLoader != null) {
            classLoader = (ClassLoader)this.m_aClassLoader.get();
        }
        return classLoader != null ? classLoader : ClassLoaderHelper.getDefaultClassLoader();
    }

    @Nonnull
    private JAXBContext _createFromPackageAndClassLoader(@Nonnull ConditionalLogger conditionalLogger) {
        ClassLoader classLoader = this._getClassLoader();
        conditionalLogger.info(() -> "Creating JAXB context for packages " + StringHelper.imploder().source(this.m_aPackages, package_ -> "'" + package_.getName() + "'").separator(", ").build() + " using ClassLoader " + classLoader.toString());
        try {
            return JAXBContext.newInstance(this.m_sEqualsHashCodeKey, classLoader);
        }
        catch (JAXBException jAXBException) {
            String string = "Failed to create JAXB context for packages " + StringHelper.imploder().source(this.m_aPackages, package_ -> "'" + package_.getName() + "'").separator(", ").build() + " using ClassLoader " + classLoader;
            LOGGER.error(string + ": " + jAXBException.getMessage());
            throw new IllegalArgumentException(string, jAXBException);
        }
    }

    @Nonnull
    private JAXBContext _createFromClassesAndProperties(@Nonnull ConditionalLogger conditionalLogger) {
        ICommonsList<Class<?>> iCommonsList = this._getAllClasses();
        conditionalLogger.info(() -> "Creating JAXB context for classes " + StringHelper.imploder().source(iCommonsList, clazz -> "'" + clazz.getName() + "'").separator(", ").build() + (String)(this.m_aProperties.isEmpty() ? "" : " with properties " + this.m_aProperties.keySet()));
        try {
            Class<?>[] classArray = iCommonsList.toArray(ArrayHelper.EMPTY_CLASS_ARRAY);
            return JAXBContext.newInstance(classArray, this.m_aProperties);
        }
        catch (JAXBException jAXBException) {
            String string = "Failed to create JAXB context for classes " + StringHelper.imploder().source(iCommonsList, clazz -> "'" + clazz.getName() + "'").separator(", ").build() + (String)(this.m_aProperties.isEmpty() ? "" : " with properties " + this.m_aProperties.keySet());
            LOGGER.error(string + ": " + jAXBException.getMessage());
            throw new IllegalArgumentException(string, jAXBException);
        }
    }

    @Nonnull
    public JAXBContext createJAXBContext(@Nonnull ConditionalLogger conditionalLogger) {
        if (this.m_aPackages != null) {
            return this._createFromPackageAndClassLoader(conditionalLogger);
        }
        return this._createFromClassesAndProperties(conditionalLogger);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JAXBContextCacheKey jAXBContextCacheKey = (JAXBContextCacheKey)object;
        return this.m_sEqualsHashCodeKey.equals(jAXBContextCacheKey.m_sEqualsHashCodeKey) && EqualsHelper.equals(this._getClassLoader(), jAXBContextCacheKey._getClassLoader()) && EqualsHelper.equals(this.m_aProperties, jAXBContextCacheKey.m_aProperties);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_sEqualsHashCodeKey).append(this._getClassLoader()).append((Map)this.m_aProperties)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("Packages", this.m_aPackages).appendIfNotNull("ClassLoader", this.m_aClassLoader).appendIfNotNull("Classes", this.m_aClasses).appendIfNotNull("Properties", this.m_aProperties).appendIfNotNull("EqualsHashCodeKey", this.m_sEqualsHashCodeKey).getToString();
    }

    @Nonnull
    public static JAXBContextCacheKey createForPackage(@Nonnull Package package_) {
        return JAXBContextCacheKey.createForPackage(package_, null);
    }

    @Nonnull
    public static JAXBContextCacheKey createForPackage(@Nonnull Package package_, @Nullable ClassLoader classLoader) {
        ValueEnforcer.notNull(package_, "Package");
        return new JAXBContextCacheKey(new CommonsArrayList<Package>(package_), classLoader);
    }

    @Nonnull
    public static JAXBContextCacheKey createForPackages(@Nonnull ICommonsList<Package> iCommonsList) {
        return JAXBContextCacheKey.createForPackages(iCommonsList, null);
    }

    @Nonnull
    public static JAXBContextCacheKey createForPackages(Package ... packageArray) {
        return JAXBContextCacheKey.createForPackages(new CommonsArrayList<Package>(packageArray), null);
    }

    @Nonnull
    public static JAXBContextCacheKey createForPackages(@Nonnull ICommonsList<Package> iCommonsList, @Nullable ClassLoader classLoader) {
        return new JAXBContextCacheKey(iCommonsList, classLoader);
    }

    @Nonnull
    public static JAXBContextCacheKey createForClass(@Nonnull Class<?> clazz) {
        return JAXBContextCacheKey.createForClass(clazz, null);
    }

    @Nonnull
    public static JAXBContextCacheKey createForClass(@Nonnull Class<?> clazz, @Nullable ClassLoader classLoader) {
        ValueEnforcer.notNull(clazz, "Class");
        Package package_ = clazz.getPackage();
        if (package_.getAnnotation(XmlSchema.class) != null) {
            return JAXBContextCacheKey.createForPackage(package_, classLoader);
        }
        return new JAXBContextCacheKey(new CommonsArrayList(clazz), (Map)null);
    }

    @Nonnull
    public static JAXBContextCacheKey createForClasses(@Nonnull ICommonsList<Class<?>> iCommonsList) {
        return JAXBContextCacheKey.createForClasses(iCommonsList, null);
    }

    @Nonnull
    public static JAXBContextCacheKey createForClasses(Class<?> ... classArray) {
        return JAXBContextCacheKey.createForClasses(new CommonsArrayList((ELEMENTTYPE[])classArray), null);
    }

    @Nonnull
    public static JAXBContextCacheKey createForClasses(@Nonnull ICommonsList<Class<?>> iCommonsList, @Nullable Map<String, ?> map) {
        ValueEnforcer.notEmptyNoNullValue(iCommonsList, "Classes");
        return new JAXBContextCacheKey(iCommonsList, map);
    }
}

