/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.adapter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.datetime.OffsetDate;
import com.helger.commons.datetime.PDTWebDateHelper;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdapterOffsetDate
extends XmlAdapter<String, OffsetDate> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdapterOffsetDate.class);
    private static Function<LocalDate, ZoneOffset> s_aZOSupplier = localDate -> ZoneOffset.UTC;

    @Nonnull
    public static Function<LocalDate, ZoneOffset> getFallbackZoneOffsetSupplier() {
        return s_aZOSupplier;
    }

    @Nonnull
    public static void setFallbackZoneOffsetSupplier(@Nonnull Function<LocalDate, ZoneOffset> function) {
        ValueEnforcer.notNull(function, "ZoneOffsetSupplier");
        s_aZOSupplier = function;
    }

    @Override
    public OffsetDate unmarshal(@Nullable String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        OffsetDate offsetDate = PDTWebDateHelper.getOffsetDateFromXSD(string2);
        if (offsetDate == null) {
            LocalDate localDate = PDTWebDateHelper.getLocalDateFromXSD(string2);
            if (localDate != null) {
                offsetDate = OffsetDate.of(localDate, AdapterOffsetDate.getFallbackZoneOffsetSupplier().apply(localDate));
            } else {
                LOGGER.warn("Failed to parse '" + string + "' to an OffsetDate");
            }
        }
        return offsetDate;
    }

    @Override
    public String marshal(@Nullable OffsetDate offsetDate) {
        return PDTWebDateHelper.getAsStringXSD(offsetDate);
    }
}

