/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.validation;

import com.helger.commons.error.IError;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.jaxb.validation.AbstractValidationEventHandler;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class LoggingValidationEventHandler
extends AbstractValidationEventHandler {
    public static final LoggingValidationEventHandler DEFAULT_INSTANCE = new LoggingValidationEventHandler();
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingValidationEventHandler.class);

    @Override
    protected void onEvent(@Nonnull IError iError) {
        String string = "JAXB " + iError.getAsString(Locale.US);
        if (iError.getErrorLevel().isLE(EErrorLevel.WARN)) {
            LOGGER.warn(string, iError.getLinkedException());
        } else {
            LOGGER.error(string, iError.getLinkedException());
        }
    }
}

