/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.iterate.IIterableIterator;
import com.helger.commons.string.ToStringGenerator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RecursiveNodeIterator
implements IIterableIterator<Node> {
    private final ICommonsList<Node> m_aOpen = new CommonsArrayList<Node>();

    public RecursiveNodeIterator(@Nonnull Node node) {
        ValueEnforcer.notNull(node, "Node");
        this.m_aOpen.add(node);
    }

    @Override
    public boolean hasNext() {
        return this.m_aOpen.isNotEmpty();
    }

    @Override
    @Nonnull
    public Node next() {
        if (this.m_aOpen.isEmpty()) {
            throw new NoSuchElementException();
        }
        Node node = (Node)this.m_aOpen.remove(0);
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            int n = nodeList.getLength();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                this.m_aOpen.add(n2, nodeList.item(i));
                ++n2;
            }
        }
        return node;
    }

    public String toString() {
        return new ToStringGenerator(this).append("Open", this.m_aOpen).getToString();
    }

    @Nonnull
    public static RecursiveNodeIterator createChildNodeIterator(@Nonnull Node node) {
        RecursiveNodeIterator recursiveNodeIterator = new RecursiveNodeIterator(node);
        recursiveNodeIterator.next();
        return recursiveNodeIterator;
    }
}

