/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.collection.impl.CommonsEnumMap;
import com.helger.commons.collection.impl.ICommonsIterable;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.state.EChange;
import com.helger.commons.state.EContinue;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xml.microdom.AbstractMicroNodeWithChildren;
import com.helger.xml.microdom.EMicroEvent;
import com.helger.xml.microdom.IMicroCDATA;
import com.helger.xml.microdom.IMicroComment;
import com.helger.xml.microdom.IMicroContainer;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroDocumentType;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroEntityReference;
import com.helger.xml.microdom.IMicroEvent;
import com.helger.xml.microdom.IMicroEventTarget;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroProcessingInstruction;
import com.helger.xml.microdom.IMicroText;
import com.helger.xml.microdom.MicroEvent;
import com.helger.xml.microdom.MicroException;
import java.util.EnumMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractMicroNode
implements IMicroNode {
    private AbstractMicroNodeWithChildren m_aParentNode;
    private CommonsEnumMap<EMicroEvent, CallbackList<IMicroEventTarget>> m_aEventTargets;

    @OverrideOnDemand
    protected void onAppendChild(@Nonnull AbstractMicroNode abstractMicroNode) {
        throw new MicroException("Cannot append children in class " + this.getClass().getName());
    }

    @OverrideOnDemand
    protected void onInsertBefore(@Nonnull AbstractMicroNode abstractMicroNode, @Nonnull IMicroNode iMicroNode) {
        throw new MicroException("Cannot insert children in class " + this.getClass().getName());
    }

    @OverrideOnDemand
    protected void onInsertAfter(@Nonnull AbstractMicroNode abstractMicroNode, @Nonnull IMicroNode iMicroNode) {
        throw new MicroException("Cannot insert children in class " + this.getClass().getName());
    }

    @OverrideOnDemand
    protected void onInsertAtIndex(@Nonnegative int n, @Nonnull AbstractMicroNode abstractMicroNode) {
        throw new MicroException("Cannot insert children in class " + this.getClass().getName());
    }

    @Override
    @Nullable
    public final <NODETYPE extends IMicroNode> NODETYPE appendChild(@Nullable NODETYPE NODETYPE) {
        if (NODETYPE != null) {
            this.onAppendChild((AbstractMicroNode)NODETYPE);
        }
        return NODETYPE;
    }

    @Override
    @Nullable
    public final <NODETYPE extends IMicroNode> NODETYPE insertBefore(@Nullable NODETYPE NODETYPE, @Nonnull IMicroNode iMicroNode) {
        if (NODETYPE != null) {
            this.onInsertBefore((AbstractMicroNode)NODETYPE, iMicroNode);
        }
        return NODETYPE;
    }

    @Override
    @Nullable
    public final <NODETYPE extends IMicroNode> NODETYPE insertAfter(@Nullable NODETYPE NODETYPE, @Nonnull IMicroNode iMicroNode) {
        if (NODETYPE != null) {
            this.onInsertAfter((AbstractMicroNode)NODETYPE, iMicroNode);
        }
        return NODETYPE;
    }

    @Override
    @Nullable
    public final <NODETYPE extends IMicroNode> NODETYPE insertAtIndex(@Nonnegative int n, @Nullable NODETYPE NODETYPE) {
        if (NODETYPE != null) {
            this.onInsertAtIndex(n, (AbstractMicroNode)NODETYPE);
        }
        return NODETYPE;
    }

    @Nonnull
    @OverrideOnDemand
    protected EChange onRemoveChild(IMicroNode iMicroNode) {
        throw new MicroException("Cannot remove child from this node: " + this.getClass().getName());
    }

    @Override
    @Nonnull
    public final EChange removeChild(@Nonnull IMicroNode iMicroNode) {
        ValueEnforcer.notNull(iMicroNode, "Child");
        return this.onRemoveChild(iMicroNode);
    }

    @Nonnull
    @OverrideOnDemand
    protected EChange onRemoveChildAtIndex(int n) {
        throw new MicroException("Cannot remove child from this node: " + this.getClass().getName());
    }

    @Override
    @Nonnull
    public final EChange removeChildAtIndex(@Nonnegative int n) {
        return this.onRemoveChildAtIndex(n);
    }

    @Nonnull
    @OverrideOnDemand
    protected EChange onRemoveAllChildren() {
        throw new MicroException("Cannot remove all children from this node: " + this.getClass().getName());
    }

    @Override
    @Nonnull
    public final EChange removeAllChildren() {
        return this.onRemoveAllChildren();
    }

    @Override
    @OverrideOnDemand
    public boolean hasChildren() {
        return false;
    }

    @Override
    @Nullable
    @OverrideOnDemand
    public ICommonsList<IMicroNode> getAllChildren() {
        return null;
    }

    @Override
    @Nullable
    @OverrideOnDemand
    public ICommonsIterable<IMicroNode> getChildren() {
        return null;
    }

    @Override
    public void forAllChildren(@Nonnull Consumer<? super IMicroNode> consumer) {
    }

    @Override
    @Nonnull
    public EContinue forAllChildrenBreakable(@Nonnull Function<? super IMicroNode, EContinue> function) {
        return EContinue.CONTINUE;
    }

    @Override
    public void forAllChildren(@Nonnull Predicate<? super IMicroNode> predicate, @Nonnull Consumer<? super IMicroNode> consumer) {
    }

    @Override
    public <DSTTYPE> void forAllChildrenMapped(@Nonnull Predicate<? super IMicroNode> predicate, @Nonnull Function<? super IMicroNode, ? extends DSTTYPE> function, @Nonnull Consumer<? super DSTTYPE> consumer) {
    }

    @Override
    @Nullable
    @OverrideOnDemand
    public IMicroNode getChildAtIndex(@Nonnegative int n) {
        return null;
    }

    @Override
    @Nonnegative
    @OverrideOnDemand
    public int getChildCount() {
        return 0;
    }

    @Override
    @Nullable
    @OverrideOnDemand
    public IMicroNode getFirstChild() {
        return null;
    }

    @Override
    @Nullable
    public IMicroNode findFirstChild(@Nonnull Predicate<? super IMicroNode> predicate) {
        return null;
    }

    @Override
    @Nullable
    public <DSTTYPE> DSTTYPE findFirstChildMapped(@Nonnull Predicate<? super IMicroNode> predicate, @Nonnull Function<? super IMicroNode, ? extends DSTTYPE> function) {
        return null;
    }

    @Override
    @Nullable
    @OverrideOnDemand
    public IMicroNode getLastChild() {
        return null;
    }

    @Override
    @Nullable
    public final IMicroNode getPreviousSibling() {
        if (this.m_aParentNode == null) {
            return null;
        }
        ICommonsList<IMicroNode> iCommonsList = this.m_aParentNode.directGetAllChildren();
        int n = iCommonsList.indexOf(this);
        if (n == -1) {
            throw new IllegalStateException("this is no part of it's parents children");
        }
        return (IMicroNode)iCommonsList.getAtIndex(n - 1);
    }

    @Override
    @Nullable
    public final IMicroNode getNextSibling() {
        if (this.m_aParentNode == null) {
            return null;
        }
        ICommonsList<IMicroNode> iCommonsList = this.m_aParentNode.directGetAllChildren();
        int n = iCommonsList.indexOf(this);
        if (n == -1) {
            throw new IllegalStateException("this is no part of it's parents children");
        }
        return (IMicroNode)iCommonsList.getAtIndex(n + 1);
    }

    @Override
    public final boolean hasParent() {
        return this.m_aParentNode != null;
    }

    @Override
    @Nullable
    public final IMicroNode getParent() {
        return this.m_aParentNode;
    }

    protected final void internalResetParentNode() {
        this.m_aParentNode = null;
    }

    protected final void internalSetParentNode(@Nonnull AbstractMicroNodeWithChildren abstractMicroNodeWithChildren) {
        if (abstractMicroNodeWithChildren == null) {
            throw new MicroException("No parent node passed!");
        }
        if (abstractMicroNodeWithChildren == this) {
            throw new MicroException("Node cannot have itself as parent: " + this.toString());
        }
        if (this.m_aParentNode != null) {
            throw new MicroException("Node already has a parent: " + this.toString());
        }
        this.m_aParentNode = abstractMicroNodeWithChildren;
    }

    @Override
    @Nonnull
    public final IMicroNode detachFromParent() {
        if (this.m_aParentNode != null) {
            if (this.m_aParentNode.removeChild(this).isUnchanged()) {
                throw new IllegalStateException("Failed to remove this from parents child list");
            }
            this.internalResetParentNode();
        }
        return this;
    }

    @Override
    @Nullable
    public IMicroElement findParentElement(@Nonnull Predicate<? super IMicroElement> predicate) {
        for (IMicroNode iMicroNode = this.m_aParentNode; iMicroNode != null && iMicroNode.isElement(); iMicroNode = iMicroNode.getParent()) {
            IMicroElement iMicroElement = (IMicroElement)iMicroNode;
            if (!predicate.test(iMicroElement)) continue;
            return iMicroElement;
        }
        return null;
    }

    @Override
    public final boolean isDocument() {
        return this instanceof IMicroDocument;
    }

    @Override
    public final boolean isDocumentType() {
        return this instanceof IMicroDocumentType;
    }

    @Override
    public final boolean isText() {
        return this instanceof IMicroText;
    }

    @Override
    public final boolean isCDATA() {
        return this instanceof IMicroCDATA;
    }

    @Override
    public final boolean isComment() {
        return this instanceof IMicroComment;
    }

    @Override
    public final boolean isEntityReference() {
        return this instanceof IMicroEntityReference;
    }

    @Override
    public final boolean isElement() {
        return this instanceof IMicroElement;
    }

    @Override
    public final boolean isProcessingInstruction() {
        return this instanceof IMicroProcessingInstruction;
    }

    @Override
    public final boolean isContainer() {
        return this instanceof IMicroContainer;
    }

    protected final void internalTriggerEvent(@Nonnull EMicroEvent eMicroEvent, @Nonnull IMicroEvent iMicroEvent) {
        CallbackList callbackList;
        if (this.m_aEventTargets != null && this.m_aEventTargets.isNotEmpty() && (callbackList = (CallbackList)this.m_aEventTargets.get(eMicroEvent)) != null) {
            callbackList.forEach(iMicroEventTarget -> iMicroEventTarget.handleEvent(iMicroEvent));
        }
        if (this.m_aParentNode != null) {
            this.m_aParentNode.internalTriggerEvent(eMicroEvent, iMicroEvent);
        }
    }

    protected final void onEvent(@Nonnull EMicroEvent eMicroEvent, @Nonnull IMicroNode iMicroNode, @Nonnull IMicroNode iMicroNode2) {
        this.internalTriggerEvent(eMicroEvent, new MicroEvent(eMicroEvent, iMicroNode, iMicroNode2));
    }

    @Override
    @Nonnull
    public EChange registerEventTarget(@Nonnull EMicroEvent eMicroEvent2, @Nonnull IMicroEventTarget iMicroEventTarget) {
        ValueEnforcer.notNull(eMicroEvent2, "EventType");
        ValueEnforcer.notNull(iMicroEventTarget, "EventTarget");
        if (this.m_aEventTargets == null) {
            this.m_aEventTargets = new CommonsEnumMap(EMicroEvent.class);
        }
        CallbackList callbackList = this.m_aEventTargets.computeIfAbsent(eMicroEvent2, eMicroEvent -> new CallbackList());
        return EChange.valueOf(callbackList.add(iMicroEventTarget));
    }

    @Override
    @Nonnull
    public EChange unregisterEventTarget(@Nonnull EMicroEvent eMicroEvent, @Nonnull IMicroEventTarget iMicroEventTarget) {
        CallbackList callbackList;
        ValueEnforcer.notNull(eMicroEvent, "EventType");
        ValueEnforcer.notNull(iMicroEventTarget, "EventTarget");
        if (this.m_aEventTargets != null && this.m_aEventTargets.isNotEmpty() && (callbackList = (CallbackList)this.m_aEventTargets.get(eMicroEvent)) != null) {
            return callbackList.removeObject(iMicroEventTarget);
        }
        return EChange.UNCHANGED;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<EMicroEvent, CallbackList<IMicroEventTarget>> getAllEventTargets() {
        return new CommonsEnumMap<EMicroEvent, CallbackList<IMicroEventTarget>>((EnumMap<EMicroEvent, CallbackList<IMicroEventTarget>>)this.m_aEventTargets);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public CallbackList<IMicroEventTarget> getAllEventTargets(@Nullable EMicroEvent eMicroEvent) {
        return new CallbackList<IMicroEventTarget>(this.m_aEventTargets == null ? null : (CallbackList)this.m_aEventTargets.get(eMicroEvent));
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("ParentNodeName", this.m_aParentNode == null ? null : this.m_aParentNode.getNodeName()).appendIfNotNull("EventTargets", this.m_aEventTargets).getToString();
    }
}

