/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.resourcebundle;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.io.resource.URLResource;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.ClassLoaderHelper;
import com.helger.xml.resourcebundle.XMLResourceBundle;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;

public final class XMLResourceBundleControl
extends ResourceBundle.Control {
    private static final String FORMAT_XML = "xml";
    private static final ICommonsList<String> FORMATS = new CommonsArrayList<String>("xml");

    @Override
    @ReturnsMutableCopy
    @CodingStyleguideUnaware
    public List<String> getFormats(@Nonnull String string) {
        ValueEnforcer.notNull(string, "BaseName");
        return (List)FORMATS.getClone();
    }

    @Override
    public ResourceBundle newBundle(@Nonnull String string, @Nonnull Locale locale, @Nonnull String string2, @Nonnull ClassLoader classLoader, boolean bl) throws IOException {
        String string3;
        String string4;
        URL uRL;
        ValueEnforcer.notNull(string, "BaseName");
        ValueEnforcer.notNull(locale, "Locale");
        ValueEnforcer.notNull(string2, "Format");
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        if (string2.equals(FORMAT_XML) && (uRL = ClassLoaderHelper.getResource(classLoader, string4 = this.toResourceName(string3 = this.toBundleName(string, locale), string2))) != null) {
            try (InputStream inputStream = URLResource.getInputStream(uRL);){
                XMLResourceBundle xMLResourceBundle;
                block13: {
                    InputStream inputStream2 = StreamHelper.getBuffered(inputStream);
                    try {
                        xMLResourceBundle = new XMLResourceBundle(inputStream2);
                        if (inputStream2 == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (inputStream2 != null) {
                            try {
                                inputStream2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    inputStream2.close();
                }
                return xMLResourceBundle;
            }
        }
        return null;
    }
}

