/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.util.thread;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.lang.StackTraceHelper;
import com.helger.commons.string.StringHelper;
import com.helger.xml.microdom.IHasMicroNodeRepresentation;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadDescriptor
implements IHasMicroNodeRepresentation {
    public static final boolean DEFAULT_ENABLE_THREAD_INFO = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadDescriptor.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    private static final ThreadMXBean THREAD_MX = ManagementFactory.getThreadMXBean();
    private static boolean s_bEnableThreadInfo = false;
    private final long m_nID;
    private final String m_sName;
    private final Thread.State m_eState;
    private final int m_nPriority;
    private final String m_sThreadGroup;
    private final String m_sStackTrace;
    private final ThreadInfo m_aThreadInfo;

    public static void setEnableThreadInfo(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bEnableThreadInfo = bl;
        });
    }

    public static boolean isEnableThreadInfo() {
        return RW_LOCK.readLockedBoolean(() -> s_bEnableThreadInfo);
    }

    public ThreadDescriptor(@Nonnull Thread thread, @Nullable String string) {
        ValueEnforcer.notNull(thread, "Thread");
        this.m_nID = thread.getId();
        this.m_sName = thread.getName();
        this.m_eState = thread.getState();
        this.m_nPriority = thread.getPriority();
        ThreadGroup threadGroup = thread.getThreadGroup();
        this.m_sThreadGroup = threadGroup != null ? threadGroup.getName() : "none - DIED!";
        this.m_sStackTrace = string;
        ThreadInfo threadInfo = null;
        try {
            if (ThreadDescriptor.isEnableThreadInfo()) {
                threadInfo = THREAD_MX.getThreadInfo(new long[]{this.m_nID}, true, true)[0];
            }
        }
        catch (Exception exception) {
            LOGGER.error("Failed to get ThreadInfo for thread " + this.m_nID + ":", exception);
        }
        this.m_aThreadInfo = threadInfo;
    }

    public long getThreadID() {
        return this.m_nID;
    }

    public Thread.State getThreadState() {
        return this.m_eState;
    }

    @Nonnull
    @Nonempty
    public String getDescriptor() {
        return "Thread[" + this.m_nID + "][" + this.m_sName + "][" + this.m_eState + "][" + this.m_nPriority + "][" + this.m_sThreadGroup + "]";
    }

    @Nullable
    public String getStackTrace() {
        return this.m_sStackTrace;
    }

    @Nonnull
    @Nonempty
    public String getStackTraceNotNull() {
        return StringHelper.hasText(this.m_sStackTrace) ? this.m_sStackTrace : "No stack trace available\n";
    }

    @Nonnull
    public String getLockInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.m_aThreadInfo != null) {
            try {
                LockInfo[] lockInfoArray;
                MonitorInfo[] monitorInfoArray = this.m_aThreadInfo.getLockedMonitors();
                if (ArrayHelper.isNotEmpty(monitorInfoArray)) {
                    stringBuilder.append("Information on ").append(monitorInfoArray.length).append(" monitors:\n");
                    lockInfoArray = monitorInfoArray;
                    int n = lockInfoArray.length;
                    for (int i = 0; i < n; ++i) {
                        LockInfo lockInfo = lockInfoArray[i];
                        stringBuilder.append("  monitor: ").append(lockInfo.getClassName()).append('@').append(Integer.toHexString(lockInfo.getIdentityHashCode())).append(" at ").append(((MonitorInfo)lockInfo).getLockedStackFrame()).append(" [").append(((MonitorInfo)lockInfo).getLockedStackDepth()).append("]\n");
                    }
                }
                if (ArrayHelper.isNotEmpty(lockInfoArray = this.m_aThreadInfo.getLockedSynchronizers())) {
                    stringBuilder.append("Information on ").append(lockInfoArray.length).append(" synchronizers:\n");
                    for (LockInfo lockInfo : lockInfoArray) {
                        stringBuilder.append("  lock:").append(lockInfo.getClassName()).append('@').append(Integer.toHexString(lockInfo.getIdentityHashCode())).append('\n');
                    }
                }
            }
            catch (Exception exception) {
                stringBuilder.append("Error retrieving infos: ").append(exception.toString());
            }
        }
        return stringBuilder.toString();
    }

    @Nonnull
    @Nonempty
    public String getAsString() {
        String string = this.getDescriptor();
        String string2 = this.getStackTraceNotNull();
        String string3 = this.getLockInfo();
        return string + "\n" + string2 + string3;
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroNode() {
        MicroElement microElement = new MicroElement("thread");
        microElement.setAttribute("id", this.m_nID);
        microElement.setAttribute("name", this.m_sName);
        if (this.m_eState != null) {
            microElement.setAttribute("state", this.m_eState.toString());
        }
        microElement.setAttribute("priority", this.m_nPriority);
        microElement.setAttribute("threadgroup", this.m_sThreadGroup);
        microElement.appendElement("stacktrace").appendText(this.getStackTraceNotNull());
        if (this.m_aThreadInfo != null) {
            IMicroElement iMicroElement = microElement.appendElement("threadinfo");
            try {
                LockInfo[] lockInfoArray;
                MonitorInfo[] monitorInfoArray = this.m_aThreadInfo.getLockedMonitors();
                if (ArrayHelper.isNotEmpty(monitorInfoArray)) {
                    lockInfoArray = iMicroElement.appendElement("monitorinfos");
                    lockInfoArray.setAttribute("count", monitorInfoArray.length);
                    for (MonitorInfo monitorInfo : monitorInfoArray) {
                        IMicroElement object = lockInfoArray.appendElement("monitor");
                        object.setAttribute("classname", monitorInfo.getClassName());
                        object.setAttribute("identity", Integer.toHexString(monitorInfo.getIdentityHashCode()));
                        if (monitorInfo.getLockedStackFrame() != null) {
                            object.setAttribute("stackframe", monitorInfo.getLockedStackFrame().toString());
                        }
                        if (monitorInfo.getLockedStackDepth() < 0) continue;
                        object.setAttribute("stackdepth", monitorInfo.getLockedStackDepth());
                    }
                }
                if (ArrayHelper.isNotEmpty(lockInfoArray = this.m_aThreadInfo.getLockedSynchronizers())) {
                    MonitorInfo[] monitorInfoArray2 = iMicroElement.appendElement("synchronizers");
                    monitorInfoArray2.setAttribute("count", lockInfoArray.length);
                    for (LockInfo lockInfo : lockInfoArray) {
                        IMicroElement iMicroElement2 = monitorInfoArray2.appendElement("synchronizer");
                        iMicroElement2.setAttribute("classname", lockInfo.getClassName());
                        iMicroElement2.setAttribute("identity", Integer.toHexString(lockInfo.getIdentityHashCode()));
                    }
                }
            }
            catch (Exception exception) {
                ((IMicroElement)iMicroElement.setAttribute("error", exception.getMessage())).appendText(StackTraceHelper.getStackAsString(exception));
            }
        }
        return microElement;
    }

    @Nonnull
    public static ThreadDescriptor createForCurrentThread(@Nullable Throwable throwable) {
        String string = StackTraceHelper.getStackAsString(throwable, false);
        return new ThreadDescriptor(Thread.currentThread(), string);
    }
}

