/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.pdf.AbstractPDFStream;
import org.apache.fop.pdf.DestinationComparator;
import org.apache.fop.pdf.FileIDGenerator;
import org.apache.fop.pdf.ObjectStreamManager;
import org.apache.fop.pdf.PDFDestination;
import org.apache.fop.pdf.PDFDests;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFEncryption;
import org.apache.fop.pdf.PDFEncryptionManager;
import org.apache.fop.pdf.PDFEncryptionParams;
import org.apache.fop.pdf.PDFFactory;
import org.apache.fop.pdf.PDFFileSpec;
import org.apache.fop.pdf.PDFFont;
import org.apache.fop.pdf.PDFFormXObject;
import org.apache.fop.pdf.PDFFunction;
import org.apache.fop.pdf.PDFGState;
import org.apache.fop.pdf.PDFGoTo;
import org.apache.fop.pdf.PDFGoToRemote;
import org.apache.fop.pdf.PDFImage;
import org.apache.fop.pdf.PDFImageXObject;
import org.apache.fop.pdf.PDFInfo;
import org.apache.fop.pdf.PDFLaunch;
import org.apache.fop.pdf.PDFLayer;
import org.apache.fop.pdf.PDFLink;
import org.apache.fop.pdf.PDFNavigator;
import org.apache.fop.pdf.PDFNavigatorAction;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFOutline;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFPages;
import org.apache.fop.pdf.PDFParentTree;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.pdf.PDFProfile;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFRoot;
import org.apache.fop.pdf.PDFShading;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFStructElem;
import org.apache.fop.pdf.PDFStructTreeRoot;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.pdf.StandardStructureAttributes;
import org.apache.fop.pdf.Version;
import org.apache.fop.pdf.VersionController;
import org.apache.fop.pdf.xref.CrossReferenceStream;
import org.apache.fop.pdf.xref.CrossReferenceTable;
import org.apache.fop.pdf.xref.TrailerDictionary;
import org.apache.xmlgraphics.image.loader.util.SoftMapCache;

public class PDFDocument {
    public static final String ENCODING = "ISO-8859-1";
    protected int objectcount;
    private Log log = LogFactory.getLog("org.apache.fop.pdf");
    protected long position;
    protected List<Long> indirectObjectOffsets = new ArrayList<Long>();
    protected List<PDFStructElem> structureTreeElements;
    protected List<PDFObject> trailerObjects = new ArrayList<PDFObject>();
    protected List<PDFObject> objects = new LinkedList<PDFObject>();
    private VersionController versionController;
    private PDFProfile pdfProfile = new PDFProfile(this);
    private PDFRoot root;
    private PDFOutline outlineRoot;
    private PDFPages pages;
    private PDFInfo info;
    private PDFResources resources;
    private PDFEncryption encryption;
    private PDFDeviceColorSpace colorspace = new PDFDeviceColorSpace(2);
    private int patternCount;
    private int shadingCount;
    private int xObjectCount;
    protected int gStateObjectCount;
    private Map<String, PDFXObject> xObjectsMap = new HashMap<String, PDFXObject>();
    private SoftMapCache xObjectsMapFast = new SoftMapCache(false);
    private Map<String, PDFFont> fontMap = new HashMap<String, PDFFont>();
    private Map<String, List<String>> filterMap = new HashMap<String, List<String>>();
    private List<PDFGState> gstates = new ArrayList<PDFGState>();
    private List<PDFFunction> functions = new ArrayList<PDFFunction>();
    private List<PDFShading> shadings = new ArrayList<PDFShading>();
    private List<PDFPattern> patterns = new ArrayList<PDFPattern>();
    private List<PDFLink> links = new ArrayList<PDFLink>();
    private List<PDFDestination> destinations;
    private List<PDFFileSpec> filespecs = new ArrayList<PDFFileSpec>();
    private List<PDFGoToRemote> gotoremotes = new ArrayList<PDFGoToRemote>();
    private List<PDFGoTo> gotos = new ArrayList<PDFGoTo>();
    private List<PDFLaunch> launches = new ArrayList<PDFLaunch>();
    protected List<PDFPage> pageObjs = new ArrayList<PDFPage>();
    private List<PDFLayer> layers;
    private List<PDFNavigator> navigators;
    private List<PDFNavigatorAction> navigatorActions;
    private PDFFactory factory = new PDFFactory(this);
    private FileIDGenerator fileIDGenerator;
    private boolean accessibilityEnabled;
    private boolean mergeFontsEnabled;
    private boolean mergeFormFieldsEnabled;
    private boolean linearizationEnabled;
    private boolean formXObjectEnabled;
    protected boolean outputStarted;

    public PDFDocument(String prod) {
        this(prod, null);
        this.versionController = VersionController.getDynamicVersionController(Version.V1_4, this);
    }

    public PDFDocument(String prod, VersionController versionController) {
        this.pages = this.getFactory().makePages();
        this.root = this.getFactory().makeRoot(this.pages);
        this.resources = this.getFactory().makeResources();
        this.info = this.getFactory().makeInfo(prod);
        this.versionController = versionController;
    }

    public Version getPDFVersion() {
        return this.versionController.getPDFVersion();
    }

    public void setPDFVersion(Version version) {
        this.versionController.setPDFVersion(version);
    }

    public String getPDFVersionString() {
        return this.versionController.getPDFVersion().toString();
    }

    public PDFProfile getProfile() {
        return this.pdfProfile;
    }

    public PDFFactory getFactory() {
        return this.factory;
    }

    public static byte[] encode(String text) {
        try {
            return text.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            return text.getBytes();
        }
    }

    public static void flushTextBuffer(StringBuilder textBuffer, OutputStream out) throws IOException {
        out.write(PDFDocument.encode(textBuffer.toString()));
        textBuffer.setLength(0);
    }

    public void setProducer(String producer) {
        this.info.setProducer(producer);
    }

    public void setCreationDate(Date date) {
        this.info.setCreationDate(date);
    }

    public void setCreator(String creator) {
        this.info.setCreator(creator);
    }

    public void setFilterMap(Map<String, List<String>> map) {
        this.filterMap = map;
    }

    public Map<String, List<String>> getFilterMap() {
        return this.filterMap;
    }

    public PDFPages getPages() {
        return this.pages;
    }

    public PDFRoot getRoot() {
        return this.root;
    }

    public List<PDFStructElem> getStructureTreeElements() {
        return this.structureTreeElements;
    }

    public PDFStructTreeRoot makeStructTreeRoot(PDFParentTree parentTree) {
        PDFStructTreeRoot structTreeRoot = new PDFStructTreeRoot(parentTree);
        this.assignObjectNumber(structTreeRoot);
        this.addTrailerObject(structTreeRoot);
        this.root.setStructTreeRoot(structTreeRoot);
        this.structureTreeElements = new ArrayList<PDFStructElem>();
        return structTreeRoot;
    }

    public void registerStructureElement(PDFStructElem structElem) {
        this.structureTreeElements.add(structElem);
    }

    public void registerStructureElement(PDFStructElem structElem, StandardStructureAttributes.Table.Scope scope) {
        this.registerStructureElement(structElem);
        this.versionController.addTableHeaderScopeAttribute(structElem, scope);
    }

    public PDFInfo getInfo() {
        return this.info;
    }

    public PDFObject registerObject(PDFObject obj) {
        this.assignObjectNumber(obj);
        this.addObject(obj);
        if (obj instanceof AbstractPDFStream) {
            ((AbstractPDFStream)obj).registerChildren();
        }
        return obj;
    }

    public <T extends PDFObject> T registerTrailerObject(T obj) {
        this.assignObjectNumber(obj);
        this.addTrailerObject(obj);
        return obj;
    }

    public void assignObjectNumber(PDFObject obj) {
        if (this.outputStarted && this.isLinearizationEnabled()) {
            throw new IllegalStateException("Can't assign number after start of output");
        }
        if (obj == null) {
            throw new NullPointerException("obj must not be null");
        }
        if (obj.hasObjectNumber()) {
            throw new IllegalStateException("Error registering a PDFObject: PDFObject already has an object number");
        }
        PDFDocument currentParent = obj.getDocument();
        if (currentParent != null && currentParent != this) {
            throw new IllegalStateException("Error registering a PDFObject: PDFObject already has a parent PDFDocument");
        }
        obj.setObjectNumber(this);
        if (currentParent == null) {
            obj.setDocument(this);
        }
    }

    public void addObject(PDFObject obj) {
        if (obj instanceof PDFStructElem) {
            return;
        }
        if (obj == null) {
            throw new NullPointerException("obj must not be null");
        }
        if (!obj.hasObjectNumber()) {
            throw new IllegalStateException("Error adding a PDFObject: PDFObject doesn't have an object number");
        }
        this.objects.add(obj);
        if (obj instanceof PDFFunction) {
            this.functions.add((PDFFunction)obj);
        }
        if (obj instanceof PDFShading) {
            String shadingName = "Sh" + ++this.shadingCount;
            ((PDFShading)obj).setName(shadingName);
            this.shadings.add((PDFShading)obj);
        }
        if (obj instanceof PDFPattern) {
            String patternName = "Pa" + ++this.patternCount;
            ((PDFPattern)obj).setName(patternName);
            this.patterns.add((PDFPattern)obj);
        }
        if (obj instanceof PDFFont) {
            PDFFont font = (PDFFont)obj;
            this.fontMap.put(font.getName(), font);
        }
        if (obj instanceof PDFGState) {
            this.gstates.add((PDFGState)obj);
        }
        if (obj instanceof PDFPage) {
            this.pages.notifyKidRegistered((PDFPage)obj);
            this.pageObjs.add((PDFPage)obj);
        }
        if (obj instanceof PDFLaunch) {
            this.launches.add((PDFLaunch)obj);
        }
        if (obj instanceof PDFLink) {
            this.links.add((PDFLink)obj);
        }
        if (obj instanceof PDFFileSpec) {
            this.filespecs.add((PDFFileSpec)obj);
        }
        if (obj instanceof PDFGoToRemote) {
            this.gotoremotes.add((PDFGoToRemote)obj);
        }
        if (obj instanceof PDFLayer) {
            if (this.layers == null) {
                this.layers = new ArrayList<PDFLayer>();
            }
            this.layers.add((PDFLayer)obj);
        }
        if (obj instanceof PDFNavigator) {
            if (this.navigators == null) {
                this.navigators = new ArrayList<PDFNavigator>();
            }
            this.navigators.add((PDFNavigator)obj);
        }
        if (obj instanceof PDFNavigatorAction) {
            if (this.navigatorActions == null) {
                this.navigatorActions = new ArrayList<PDFNavigatorAction>();
            }
            this.navigatorActions.add((PDFNavigatorAction)obj);
        }
    }

    public void addTrailerObject(PDFObject obj) {
        this.trailerObjects.add(obj);
        if (obj instanceof PDFGoTo) {
            this.gotos.add((PDFGoTo)obj);
        }
    }

    public void applyEncryption(AbstractPDFStream stream) {
        if (this.isEncryptionActive()) {
            this.encryption.applyFilter(stream);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setEncryption(PDFEncryptionParams params) {
        this.getProfile().verifyEncryptionAllowed();
        this.fileIDGenerator = FileIDGenerator.getRandomFileIDGenerator();
        this.encryption = PDFEncryptionManager.newInstance(params, this);
        if (this.encryption != null) {
            PDFObject pdfObject = (PDFObject)((Object)this.encryption);
            this.addTrailerObject(pdfObject);
            try {
                if (this.encryption.getPDFVersion().compareTo(this.versionController.getPDFVersion()) <= 0) return;
                this.versionController.setPDFVersion(this.encryption.getPDFVersion());
                return;
            }
            catch (IllegalStateException ise) {
                this.log.warn("Configured encryption requires PDF version " + (Object)((Object)this.encryption.getPDFVersion()) + " but version has been set to " + (Object)((Object)this.versionController.getPDFVersion()) + ".");
                throw ise;
            }
        } else {
            this.log.warn("PDF encryption is unavailable. PDF will be generated without encryption.");
            if (params.getEncryptionLengthInBits() != 256) return;
            this.log.warn("Make sure the JCE Unlimited Strength Jurisdiction Policy files are available.AES 256 encryption cannot be performed without them.");
        }
    }

    public boolean isEncryptionActive() {
        return this.encryption != null;
    }

    public PDFEncryption getEncryption() {
        return this.encryption;
    }

    private Object findPDFObject(List<? extends PDFObject> list, PDFObject compare) {
        for (PDFObject pDFObject : list) {
            if (!compare.contentEquals(pDFObject)) continue;
            return pDFObject;
        }
        return null;
    }

    protected PDFFunction findFunction(PDFFunction compare) {
        return (PDFFunction)this.findPDFObject(this.functions, compare);
    }

    protected PDFShading findShading(PDFShading compare) {
        return (PDFShading)this.findPDFObject(this.shadings, compare);
    }

    protected PDFPattern findPattern(PDFPattern compare) {
        return (PDFPattern)this.findPDFObject(this.patterns, compare);
    }

    protected PDFFont findFont(String fontname) {
        return this.fontMap.get(fontname);
    }

    protected PDFDestination findDestination(PDFDestination compare) {
        int index = this.getDestinationList().indexOf(compare);
        if (index >= 0) {
            return this.getDestinationList().get(index);
        }
        return null;
    }

    protected PDFLink findLink(PDFLink compare) {
        return (PDFLink)this.findPDFObject(this.links, compare);
    }

    protected PDFFileSpec findFileSpec(PDFFileSpec compare) {
        return (PDFFileSpec)this.findPDFObject(this.filespecs, compare);
    }

    protected PDFGoToRemote findGoToRemote(PDFGoToRemote compare) {
        return (PDFGoToRemote)this.findPDFObject(this.gotoremotes, compare);
    }

    protected PDFGoTo findGoTo(PDFGoTo compare) {
        return (PDFGoTo)this.findPDFObject(this.gotos, compare);
    }

    protected PDFLaunch findLaunch(PDFLaunch compare) {
        return (PDFLaunch)this.findPDFObject(this.launches, compare);
    }

    protected PDFGState findGState(PDFGState wanted, PDFGState current) {
        for (PDFGState avail : this.gstates) {
            PDFGState poss = new PDFGState();
            poss.addValues(current);
            poss.addValues(avail);
            if (!poss.contentEquals(wanted)) continue;
            return avail;
        }
        return null;
    }

    public PDFDeviceColorSpace getPDFColorSpace() {
        return this.colorspace;
    }

    public int getColorSpace() {
        return this.getPDFColorSpace().getColorSpace();
    }

    public void setColorSpace(int theColorspace) {
        this.colorspace.setColorSpace(theColorspace);
    }

    public Map<String, PDFFont> getFontMap() {
        return this.fontMap;
    }

    @Deprecated
    public PDFImageXObject getImage(String key) {
        return (PDFImageXObject)this.getXObject(key);
    }

    public PDFXObject getXObject(String key) {
        Object xObj = this.xObjectsMapFast.get(key);
        if (xObj != null) {
            return (PDFXObject)xObj;
        }
        return this.xObjectsMap.get(this.toHashCode(key));
    }

    private void putXObject(String key, PDFXObject pdfxObject) {
        this.xObjectsMapFast.clear();
        this.xObjectsMapFast.put(key, pdfxObject);
        this.xObjectsMap.put(this.toHashCode(key), pdfxObject);
    }

    private String toHashCode(String key) {
        if (key.length() < 1024) {
            return key;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] thedigest = md.digest(key.getBytes("UTF-8"));
            StringBuilder hex = new StringBuilder();
            for (byte b : thedigest) {
                hex.append(String.format("%02x", b));
            }
            return hex.toString();
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public void addDestination(PDFDestination destination) {
        if (this.destinations == null) {
            this.destinations = new ArrayList<PDFDestination>();
        }
        this.destinations.add(destination);
    }

    public List<PDFDestination> getDestinationList() {
        if (this.hasDestinations()) {
            return this.destinations;
        }
        return Collections.emptyList();
    }

    public boolean hasDestinations() {
        return this.destinations != null && !this.destinations.isEmpty();
    }

    public PDFImageXObject addImage(PDFResourceContext res, PDFImage img) {
        String key = img.getKey();
        PDFImageXObject xObject = (PDFImageXObject)this.getXObject(key);
        if (xObject != null) {
            if (res != null) {
                res.addXObject(xObject);
            }
            return xObject;
        }
        img.setup(this);
        xObject = new PDFImageXObject(++this.xObjectCount, img);
        this.registerObject(xObject);
        this.resources.addXObject(xObject);
        if (res != null) {
            res.addXObject(xObject);
        }
        this.putXObject(key, xObject);
        return xObject;
    }

    public PDFFormXObject addFormXObject(PDFResourceContext res, PDFStream cont, PDFReference formres, String key) {
        PDFFormXObject xObject = (PDFFormXObject)this.getXObject(key);
        if (xObject != null) {
            if (res != null) {
                res.addXObject(xObject);
            }
            return xObject;
        }
        xObject = new PDFFormXObject(++this.xObjectCount, cont, formres);
        this.registerObject(xObject);
        this.resources.addXObject(xObject);
        if (res != null) {
            res.addXObject(xObject);
        }
        this.putXObject(key, xObject);
        return xObject;
    }

    public PDFOutline getOutlineRoot() {
        if (this.outlineRoot != null) {
            return this.outlineRoot;
        }
        this.outlineRoot = new PDFOutline(null, null, true);
        this.assignObjectNumber(this.outlineRoot);
        this.addTrailerObject(this.outlineRoot);
        this.root.setRootOutline(this.outlineRoot);
        return this.outlineRoot;
    }

    public PDFResources getResources() {
        return this.resources;
    }

    public void enableAccessibility(boolean enableAccessibility) {
        this.accessibilityEnabled = enableAccessibility;
    }

    public PDFReference resolveExtensionReference(String id) {
        if (this.layers != null) {
            for (PDFLayer layer : this.layers) {
                if (!layer.hasId(id)) continue;
                return layer.makeReference();
            }
        }
        if (this.navigators != null) {
            for (PDFNavigator navigator : this.navigators) {
                if (!navigator.hasId(id)) continue;
                return navigator.makeReference();
            }
        }
        if (this.navigatorActions != null) {
            for (PDFNavigatorAction action : this.navigatorActions) {
                if (!action.hasId(id)) continue;
                return action.makeReference();
            }
        }
        return null;
    }

    public void output(OutputStream stream) throws IOException {
        this.outputStarted = true;
        while (this.objects.size() > 0) {
            PDFObject object = this.objects.remove(0);
            this.streamIndirectObject(object, stream);
        }
    }

    protected void writeTrailer(OutputStream stream, int first, int last, int size, long mainOffset, long startxref) throws IOException {
        TrailerOutputHelper trailerOutputHelper;
        TrailerOutputHelper trailerOutputHelper2 = trailerOutputHelper = this.mayCompressStructureTreeElements() ? new CompressedTrailerOutputHelper() : new UncompressedTrailerOutputHelper();
        if (this.structureTreeElements != null) {
            trailerOutputHelper.outputStructureTreeElements(stream);
        }
        TrailerDictionary trailerDictionary = this.createTrailerDictionary(mainOffset != 0L);
        if (mainOffset != 0L) {
            trailerDictionary.getDictionary().put("Prev", mainOffset);
        }
        trailerOutputHelper.outputCrossReferenceObject(stream, trailerDictionary, first, last, size);
        String trailer = "\nstartxref\n" + startxref + "\n%%EOF\n";
        stream.write(PDFDocument.encode(trailer));
    }

    protected int streamIndirectObject(PDFObject o, OutputStream stream) throws IOException {
        this.outputStarted = true;
        this.recordObjectOffset(o);
        int len = PDFDocument.outputIndirectObject(o, stream);
        this.position += (long)len;
        return len;
    }

    private void streamIndirectObjects(Collection<? extends PDFObject> objects, OutputStream stream) throws IOException {
        for (PDFObject pDFObject : objects) {
            this.streamIndirectObject(pDFObject, stream);
        }
    }

    private void recordObjectOffset(PDFObject object) {
        int index = object.getObjectNumber().getNumber() - 1;
        while (this.indirectObjectOffsets.size() <= index) {
            this.indirectObjectOffsets.add(null);
        }
        this.indirectObjectOffsets.set(index, this.position);
    }

    public static int outputIndirectObject(PDFObject object, OutputStream stream) throws IOException {
        if (!object.hasObjectNumber()) {
            throw new IllegalArgumentException("Not an indirect object");
        }
        byte[] obj = PDFDocument.encode(object.getObjectID());
        stream.write(obj);
        int length = object.output(stream);
        byte[] endobj = PDFDocument.encode("\nendobj\n");
        stream.write(endobj);
        return obj.length + length + endobj.length;
    }

    public void outputHeader(OutputStream stream) throws IOException {
        this.position = 0L;
        this.getProfile().verifyPDFVersion();
        byte[] pdf = PDFDocument.encode("%PDF-" + this.getPDFVersionString() + "\n");
        stream.write(pdf);
        this.position += (long)pdf.length;
        byte[] bin = new byte[]{37, -86, -85, -84, -83, 10};
        stream.write(bin);
        this.position += (long)bin.length;
    }

    public void outputTrailer(OutputStream stream) throws IOException {
        this.createDestinations();
        this.output(stream);
        this.outputTrailerObjectsAndXref(stream);
    }

    private void createDestinations() {
        if (this.hasDestinations()) {
            Collections.sort(this.destinations, new DestinationComparator());
            PDFDests dests = this.getFactory().makeDests(this.destinations);
            if (this.root.getNames() == null) {
                this.root.setNames(this.getFactory().makeNames());
            }
            this.root.getNames().setDests(dests);
        }
    }

    private void outputTrailerObjectsAndXref(OutputStream stream) throws IOException {
        TrailerOutputHelper trailerOutputHelper;
        TrailerOutputHelper trailerOutputHelper2 = trailerOutputHelper = this.mayCompressStructureTreeElements() ? new CompressedTrailerOutputHelper() : new UncompressedTrailerOutputHelper();
        if (this.structureTreeElements != null) {
            Iterator<PDFStructElem> structElemIterator = this.structureTreeElements.iterator();
            while (structElemIterator.hasNext()) {
                PDFStructElem structElem = structElemIterator.next();
                if (structElem.hasObjectNumber()) continue;
                structElemIterator.remove();
                structElem.parentElement.kids.remove(structElem);
            }
            trailerOutputHelper.outputStructureTreeElements(stream);
        }
        this.streamIndirectObjects(this.trailerObjects, stream);
        TrailerDictionary trailerDictionary = this.createTrailerDictionary(true);
        long startxref = trailerOutputHelper.outputCrossReferenceObject(stream, trailerDictionary, 0, this.indirectObjectOffsets.size(), this.indirectObjectOffsets.size());
        String trailer = "\nstartxref\n" + startxref + "\n%%EOF\n";
        stream.write(PDFDocument.encode(trailer));
    }

    private boolean mayCompressStructureTreeElements() {
        return this.accessibilityEnabled && this.versionController.getPDFVersion().compareTo(Version.V1_5) >= 0 && !this.isLinearizationEnabled();
    }

    private TrailerDictionary createTrailerDictionary(boolean addRoot) {
        FileIDGenerator gen = this.getFileIDGenerator();
        TrailerDictionary trailerDictionary = new TrailerDictionary(this);
        if (addRoot) {
            trailerDictionary.setRoot(this.root).setInfo(this.info);
        }
        trailerDictionary.setFileID(gen.getOriginalFileID(), gen.getUpdatedFileID());
        if (this.isEncryptionActive()) {
            trailerDictionary.setEncryption(this.encryption);
        }
        return trailerDictionary;
    }

    public boolean isMergeFontsEnabled() {
        return this.mergeFontsEnabled;
    }

    public void setMergeFontsEnabled(boolean mergeFontsEnabled) {
        this.mergeFontsEnabled = mergeFontsEnabled;
        if (mergeFontsEnabled) {
            this.getResources().createFontsAsObj();
        }
    }

    public boolean isMergeFormFieldsEnabled() {
        return this.mergeFormFieldsEnabled;
    }

    public void setMergeFormFieldsEnabled(boolean mergeFormFieldsEnabled) {
        this.mergeFormFieldsEnabled = mergeFormFieldsEnabled;
    }

    long getCurrentFileSize() {
        return this.position;
    }

    FileIDGenerator getFileIDGenerator() {
        if (this.fileIDGenerator == null) {
            try {
                this.fileIDGenerator = FileIDGenerator.getDigestFileIDGenerator(this);
            }
            catch (NoSuchAlgorithmException e) {
                this.fileIDGenerator = FileIDGenerator.getRandomFileIDGenerator();
            }
        }
        return this.fileIDGenerator;
    }

    public boolean isLinearizationEnabled() {
        return this.linearizationEnabled;
    }

    public void setLinearizationEnabled(boolean b) {
        this.linearizationEnabled = b;
    }

    public boolean isFormXObjectEnabled() {
        return this.formXObjectEnabled;
    }

    public void setFormXObjectEnabled(boolean b) {
        this.formXObjectEnabled = b;
    }

    private class CompressedTrailerOutputHelper
    implements TrailerOutputHelper {
        private ObjectStreamManager structureTreeObjectStreams;

        private CompressedTrailerOutputHelper() {
        }

        @Override
        public void outputStructureTreeElements(OutputStream stream) throws IOException {
            assert (PDFDocument.this.structureTreeElements.size() > 0);
            this.structureTreeObjectStreams = new ObjectStreamManager(PDFDocument.this);
            for (PDFStructElem structElem : PDFDocument.this.structureTreeElements) {
                this.structureTreeObjectStreams.add(structElem);
            }
        }

        @Override
        public long outputCrossReferenceObject(OutputStream stream, TrailerDictionary trailerDictionary, int first, int last, int size) throws IOException {
            assert (PDFDocument.this.objects.isEmpty());
            new CrossReferenceStream(PDFDocument.this, ++PDFDocument.this.objectcount, trailerDictionary, PDFDocument.this.position, PDFDocument.this.indirectObjectOffsets, this.structureTreeObjectStreams.getCompressedObjectReferences()).output(stream);
            return PDFDocument.this.position;
        }
    }

    private class UncompressedTrailerOutputHelper
    implements TrailerOutputHelper {
        private UncompressedTrailerOutputHelper() {
        }

        @Override
        public void outputStructureTreeElements(OutputStream stream) throws IOException {
            PDFDocument.this.streamIndirectObjects(PDFDocument.this.structureTreeElements, stream);
        }

        @Override
        public long outputCrossReferenceObject(OutputStream stream, TrailerDictionary trailerDictionary, int first, int last, int size) throws IOException {
            new CrossReferenceTable(trailerDictionary, PDFDocument.this.position, PDFDocument.this.indirectObjectOffsets, first, last, size).output(stream);
            return PDFDocument.this.position;
        }
    }

    private static interface TrailerOutputHelper {
        public void outputStructureTreeElements(OutputStream var1) throws IOException;

        public long outputCrossReferenceObject(OutputStream var1, TrailerDictionary var2, int var3, int var4, int var5) throws IOException;
    }
}

