/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.mustangproject.Allowance;
import org.mustangproject.CashDiscount;
import org.mustangproject.Charge;
import org.mustangproject.Contact;
import org.mustangproject.FileAttachment;
import org.mustangproject.IncludedNote;
import org.mustangproject.Item;
import org.mustangproject.TradeParty;
import org.mustangproject.ZUGFeRD.IExportableTransaction;
import org.mustangproject.ZUGFeRD.IZUGFeRDAllowanceCharge;
import org.mustangproject.ZUGFeRD.IZUGFeRDCashDiscount;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableItem;
import org.mustangproject.ZUGFeRD.IZUGFeRDPaymentTerms;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlement;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Invoice
implements IExportableTransaction {
    protected String documentName = null;
    protected String documentCode = null;
    protected String number = null;
    protected String ownOrganisationFullPlaintextInfo = null;
    protected String referenceNumber = null;
    protected String shipToOrganisationID = null;
    protected String shipToOrganisationName = null;
    protected String shipToStreet = null;
    protected String shipToZIP = null;
    protected String shipToLocation = null;
    protected String shipToCountry = null;
    protected String buyerOrderReferencedDocumentID = null;
    protected String invoiceReferencedDocumentID = null;
    protected String buyerOrderReferencedDocumentIssueDateTime = null;
    protected String ownForeignOrganisationID = null;
    protected String ownOrganisationName = null;
    protected String currency = null;
    protected String paymentTermDescription = null;
    protected Date issueDate = null;
    protected Date dueDate = null;
    protected Date deliveryDate = null;
    protected TradeParty sender = null;
    protected TradeParty recipient = null;
    protected TradeParty deliveryAddress = null;
    protected TradeParty payee = null;
    protected ArrayList<CashDiscount> cashDiscounts = null;
    @JsonDeserialize(contentAs=Item.class)
    protected ArrayList<IZUGFeRDExportableItem> ZFItems = null;
    protected ArrayList<String> notes = null;
    private List<IncludedNote> includedNotes = null;
    protected String sellerOrderReferencedDocumentID;
    protected String contractReferencedDocument = null;
    protected ArrayList<FileAttachment> xmlEmbeddedFiles = null;
    protected BigDecimal totalPrepaidAmount = null;
    protected Date detailedDeliveryDateStart = null;
    protected Date detailedDeliveryPeriodEnd = null;
    protected ArrayList<IZUGFeRDAllowanceCharge> Allowances = new ArrayList();
    protected ArrayList<IZUGFeRDAllowanceCharge> Charges = new ArrayList();
    protected ArrayList<IZUGFeRDAllowanceCharge> LogisticsServiceCharges = new ArrayList();
    protected IZUGFeRDPaymentTerms paymentTerms = null;
    protected Date invoiceReferencedIssueDate;
    protected String specifiedProcuringProjectID = null;
    protected String specifiedProcuringProjectName = null;
    protected String despatchAdviceReferencedDocumentID = null;
    protected String vatDueDateTypeCode = null;
    protected String creditorReferenceID;
    private BigDecimal roundingAmount = null;

    public Invoice() {
        this.ZFItems = new ArrayList();
        this.cashDiscounts = new ArrayList();
        this.setCurrency("EUR");
    }

    @Override
    public String getDocumentName() {
        return this.documentName;
    }

    @Override
    public String getContractReferencedDocument() {
        return this.contractReferencedDocument;
    }

    public Invoice setDocumentName(String documentName) {
        this.documentName = documentName;
        return this;
    }

    @Override
    public String getDocumentCode() {
        return this.documentCode;
    }

    public Invoice setDocumentCode(String documentCode) {
        this.documentCode = documentCode;
        return this;
    }

    public Invoice embedFileInXML(FileAttachment fa) {
        if (this.xmlEmbeddedFiles == null) {
            this.xmlEmbeddedFiles = new ArrayList();
        }
        this.xmlEmbeddedFiles.add(fa);
        return this;
    }

    @Override
    public FileAttachment[] getAdditionalReferencedDocuments() {
        if (this.xmlEmbeddedFiles == null) {
            return null;
        }
        return this.xmlEmbeddedFiles.toArray(new FileAttachment[0]);
    }

    @Override
    public IZUGFeRDCashDiscount[] getCashDiscounts() {
        return this.cashDiscounts.toArray(new IZUGFeRDCashDiscount[0]);
    }

    @Override
    public String getNumber() {
        return this.number;
    }

    public Invoice setNumber(String number) {
        this.number = number;
        return this;
    }

    public Invoice setCorrection(String number) {
        this.setInvoiceReferencedDocumentID(number);
        this.documentCode = "384";
        return this;
    }

    public Invoice setCreditNote() {
        this.documentCode = "381";
        return this;
    }

    @Override
    public String getOwnOrganisationFullPlaintextInfo() {
        return this.ownOrganisationFullPlaintextInfo;
    }

    public Invoice setOwnOrganisationFullPlaintextInfo(String ownOrganisationFullPlaintextInfo) {
        this.ownOrganisationFullPlaintextInfo = ownOrganisationFullPlaintextInfo;
        return this;
    }

    @Override
    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public Invoice setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
        return this;
    }

    @Override
    public String getShipToOrganisationID() {
        return this.shipToOrganisationID;
    }

    public Invoice setShipToOrganisationID(String shipToOrganisationID) {
        this.shipToOrganisationID = shipToOrganisationID;
        return this;
    }

    @Override
    public String getShipToOrganisationName() {
        return this.shipToOrganisationName;
    }

    public Invoice setShipToOrganisationName(String shipToOrganisationName) {
        this.shipToOrganisationName = shipToOrganisationName;
        return this;
    }

    @Override
    public String getShipToStreet() {
        return this.shipToStreet;
    }

    public Invoice setShipToStreet(String shipToStreet) {
        this.shipToStreet = shipToStreet;
        return this;
    }

    @Override
    public String getShipToZIP() {
        return this.shipToZIP;
    }

    public Invoice setShipToZIP(String shipToZIP) {
        this.shipToZIP = shipToZIP;
        return this;
    }

    @Override
    public String getShipToLocation() {
        return this.shipToLocation;
    }

    public Invoice setShipToLocation(String shipToLocation) {
        this.shipToLocation = shipToLocation;
        return this;
    }

    @Override
    public String getShipToCountry() {
        return this.shipToCountry;
    }

    public Invoice setShipToCountry(String shipToCountry) {
        this.shipToCountry = shipToCountry;
        return this;
    }

    @Override
    public String getBuyerOrderReferencedDocumentID() {
        return this.buyerOrderReferencedDocumentID;
    }

    @Override
    public String getSellerOrderReferencedDocumentID() {
        return this.sellerOrderReferencedDocumentID;
    }

    public Invoice setSellerOrderReferencedDocumentID(String sellerOrderReferencedDocumentID) {
        this.sellerOrderReferencedDocumentID = sellerOrderReferencedDocumentID;
        return this;
    }

    public Invoice setBuyerOrderReferencedDocumentID(String buyerOrderReferencedDocumentID) {
        this.buyerOrderReferencedDocumentID = buyerOrderReferencedDocumentID;
        return this;
    }

    public Invoice setInvoiceReferencedDocumentID(String invoiceReferencedDocumentID) {
        this.invoiceReferencedDocumentID = invoiceReferencedDocumentID;
        return this;
    }

    @Override
    public String getInvoiceReferencedDocumentID() {
        return this.invoiceReferencedDocumentID;
    }

    @Override
    public Date getInvoiceReferencedIssueDate() {
        return this.invoiceReferencedIssueDate;
    }

    public Invoice setInvoiceReferencedIssueDate(Date issueDate) {
        this.invoiceReferencedIssueDate = issueDate;
        return this;
    }

    @Override
    public String getBuyerOrderReferencedDocumentIssueDateTime() {
        return this.buyerOrderReferencedDocumentIssueDateTime;
    }

    public Invoice setTotalPrepaidAmount(BigDecimal prepaid) {
        this.totalPrepaidAmount = prepaid;
        return this;
    }

    @Override
    public BigDecimal getTotalPrepaidAmount() {
        return this.totalPrepaidAmount;
    }

    public Invoice setBuyerOrderReferencedDocumentIssueDateTime(String buyerOrderReferencedDocumentIssueDateTime) {
        this.buyerOrderReferencedDocumentIssueDateTime = buyerOrderReferencedDocumentIssueDateTime;
        return this;
    }

    @Override
    public String getOwnTaxID() {
        return this.getSender().getTaxID();
    }

    @Deprecated
    public Invoice setOwnTaxID(String ownTaxID) {
        this.sender.addTaxID(ownTaxID);
        return this;
    }

    @Override
    public String getOwnVATID() {
        return this.getSender().getVATID();
    }

    @Deprecated
    public Invoice setOwnVATID(String ownVATID) {
        this.sender.addVATID(ownVATID);
        return this;
    }

    @Override
    public String getOwnForeignOrganisationID() {
        return this.ownForeignOrganisationID;
    }

    @Deprecated
    public Invoice setOwnForeignOrganisationID(String ownForeignOrganisationID) {
        this.ownForeignOrganisationID = ownForeignOrganisationID;
        return this;
    }

    @Override
    public String getOwnOrganisationName() {
        return this.ownOrganisationName;
    }

    @Deprecated
    public Invoice setOwnOrganisationName(String ownOrganisationName) {
        this.ownOrganisationName = ownOrganisationName;
        return this;
    }

    @Override
    public String getOwnStreet() {
        return this.sender.getStreet();
    }

    @Override
    public String getOwnZIP() {
        return this.sender.getZIP();
    }

    @Override
    public String getOwnLocation() {
        return this.sender.getLocation();
    }

    @Override
    public String getOwnCountry() {
        return this.sender.getCountry();
    }

    @Override
    public String[] getNotes() {
        if (this.notes == null) {
            return null;
        }
        return this.notes.toArray(new String[0]);
    }

    @Override
    public List<IncludedNote> getNotesWithSubjectCode() {
        return this.includedNotes;
    }

    @Override
    public String getCurrency() {
        return this.currency;
    }

    public Invoice setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    @Override
    public String getPaymentTermDescription() {
        return this.paymentTermDescription;
    }

    public Invoice setPaymentTermDescription(String paymentTermDescription) {
        this.paymentTermDescription = paymentTermDescription;
        return this;
    }

    @Override
    public Date getIssueDate() {
        return this.issueDate;
    }

    public Invoice setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
        return this;
    }

    @Override
    public Date getDueDate() {
        return this.dueDate;
    }

    public Invoice setDueDate(Date dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @Override
    public Date getDeliveryDate() {
        return this.deliveryDate;
    }

    public Invoice setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
        return this;
    }

    @Override
    public TradeParty getSender() {
        return this.sender;
    }

    @Override
    public BigDecimal getRoundingAmount() {
        return this.roundingAmount;
    }

    public Invoice setRoundingAmount(BigDecimal amount) {
        this.roundingAmount = amount;
        return this;
    }

    @Deprecated
    public Invoice setOwnContact(Contact ownContact) {
        this.sender.setContact(ownContact);
        return this;
    }

    @Override
    public TradeParty getRecipient() {
        return this.recipient;
    }

    public Invoice setRecipient(TradeParty recipient) {
        this.recipient = recipient;
        return this;
    }

    public Invoice setSender(TradeParty sender) {
        this.sender = sender;
        if (sender.getBankDetails() == null || sender.getBankDetails().size() > 0) {
            // empty if block
        }
        return this;
    }

    @Override
    public IZUGFeRDAllowanceCharge[] getZFAllowances() {
        if (this.Allowances.isEmpty()) {
            return null;
        }
        return this.Allowances.toArray(new IZUGFeRDAllowanceCharge[0]);
    }

    public Invoice setZFAllowances(Allowance[] iza) {
        this.Allowances = new ArrayList();
        for (Allowance cz : iza) {
            this.Allowances.add(cz);
        }
        return this;
    }

    @Override
    public IZUGFeRDAllowanceCharge[] getZFCharges() {
        if (this.Charges.isEmpty()) {
            return null;
        }
        return this.Charges.toArray(new IZUGFeRDAllowanceCharge[0]);
    }

    public Invoice setZFCharges(Charge[] iza) {
        this.Charges = new ArrayList();
        for (Charge cz : iza) {
            this.Charges.add(cz);
        }
        return this;
    }

    @Override
    public IZUGFeRDAllowanceCharge[] getZFLogisticsServiceCharges() {
        if (this.LogisticsServiceCharges.isEmpty()) {
            return null;
        }
        return this.LogisticsServiceCharges.toArray(new IZUGFeRDAllowanceCharge[0]);
    }

    @Override
    public IZUGFeRDTradeSettlement[] getTradeSettlement() {
        if (this.getSender() == null) {
            return null;
        }
        return this.getSender().getAsTradeSettlement();
    }

    @Override
    public IZUGFeRDPaymentTerms getPaymentTerms() {
        return this.paymentTerms;
    }

    public Invoice setPaymentTerms(IZUGFeRDPaymentTerms paymentTerms) {
        this.paymentTerms = paymentTerms;
        return this;
    }

    @Override
    public TradeParty getDeliveryAddress() {
        return this.deliveryAddress;
    }

    public Invoice setDeliveryAddress(TradeParty deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
        return this;
    }

    @Override
    public TradeParty getPayee() {
        return this.payee;
    }

    public Invoice setPayee(TradeParty payee) {
        this.payee = payee;
        return this;
    }

    public Invoice addCashDiscount(CashDiscount c) {
        this.cashDiscounts.add(c);
        return this;
    }

    @Override
    public IZUGFeRDExportableItem[] getZFItems() {
        return this.ZFItems.toArray(new IZUGFeRDExportableItem[0]);
    }

    public void setZFItems(ArrayList<IZUGFeRDExportableItem> ims) {
        this.ZFItems = ims;
    }

    public Invoice addItem(IZUGFeRDExportableItem item) {
        this.ZFItems.add(item);
        return this;
    }

    public boolean isValid() {
        return this.dueDate != null && this.sender != null && this.sender.getTaxID() != null && this.sender.getVATID() != null && this.recipient != null;
    }

    public Invoice addCharge(IZUGFeRDAllowanceCharge izac) {
        this.Charges.add(izac);
        return this;
    }

    public Invoice addAllowance(IZUGFeRDAllowanceCharge izac) {
        this.Allowances.add(izac);
        return this;
    }

    public Invoice setContractReferencedDocument(String s) {
        this.contractReferencedDocument = s;
        return this;
    }

    public Invoice setDetailedDeliveryPeriod(Date start, Date end) {
        this.detailedDeliveryDateStart = start;
        this.detailedDeliveryPeriodEnd = end;
        return this;
    }

    @Override
    public Date getDetailedDeliveryPeriodFrom() {
        return this.detailedDeliveryDateStart;
    }

    @Override
    public Date getDetailedDeliveryPeriodTo() {
        return this.detailedDeliveryPeriodEnd;
    }

    public Invoice addNote(String text) {
        if (this.notes == null) {
            this.notes = new ArrayList();
        }
        this.notes.add(text);
        return this;
    }

    public Invoice addNotes(Collection<IncludedNote> notes) {
        if (notes == null) {
            return this;
        }
        if (this.includedNotes == null) {
            this.includedNotes = new ArrayList<IncludedNote>();
        }
        this.includedNotes.addAll(notes);
        return this;
    }

    public Invoice addGeneralNote(String content) {
        if (this.includedNotes == null) {
            this.includedNotes = new ArrayList<IncludedNote>();
        }
        this.includedNotes.add(IncludedNote.generalNote(content));
        return this;
    }

    public Invoice addRegulatoryNote(String content) {
        if (this.includedNotes == null) {
            this.includedNotes = new ArrayList<IncludedNote>();
        }
        this.includedNotes.add(IncludedNote.regulatoryNote(content));
        return this;
    }

    public Invoice addLegalNote(String content) {
        if (this.includedNotes == null) {
            this.includedNotes = new ArrayList<IncludedNote>();
        }
        this.includedNotes.add(IncludedNote.legalNote(content));
        return this;
    }

    public Invoice addCustomsNote(String content) {
        if (this.includedNotes == null) {
            this.includedNotes = new ArrayList<IncludedNote>();
        }
        this.includedNotes.add(IncludedNote.customsNote(content));
        return this;
    }

    public Invoice addSellerNote(String content) {
        if (this.includedNotes == null) {
            this.includedNotes = new ArrayList<IncludedNote>();
        }
        this.includedNotes.add(IncludedNote.sellerNote(content));
        return this;
    }

    public Invoice addTaxNote(String content) {
        if (this.includedNotes == null) {
            this.includedNotes = new ArrayList<IncludedNote>();
        }
        this.includedNotes.add(IncludedNote.taxNote(content));
        return this;
    }

    public Invoice addIntroductionNote(String content) {
        if (this.includedNotes == null) {
            this.includedNotes = new ArrayList<IncludedNote>();
        }
        this.includedNotes.add(IncludedNote.introductionNote(content));
        return this;
    }

    public Invoice addDiscountBonusNote(String content) {
        if (this.includedNotes == null) {
            this.includedNotes = new ArrayList<IncludedNote>();
        }
        this.includedNotes.add(IncludedNote.discountBonusNote(content));
        return this;
    }

    @Override
    public String getSpecifiedProcuringProjectID() {
        return this.specifiedProcuringProjectID;
    }

    public Invoice setSpecifiedProcuringProjectID(String specifiedProcuringProjectID) {
        this.specifiedProcuringProjectID = specifiedProcuringProjectID;
        return this;
    }

    @Override
    public String getDespatchAdviceReferencedDocumentID() {
        return this.despatchAdviceReferencedDocumentID;
    }

    public Invoice setDespatchAdviceReferencedDocumentID(String despatchAdviceReferencedDocumentID) {
        this.despatchAdviceReferencedDocumentID = despatchAdviceReferencedDocumentID;
        return this;
    }

    @Override
    public String getSpecifiedProcuringProjectName() {
        return this.specifiedProcuringProjectName;
    }

    public Invoice setSpecifiedProcuringProjectName(String specifiedProcuringProjectName) {
        this.specifiedProcuringProjectName = specifiedProcuringProjectName;
        return this;
    }

    @Override
    public String getVATDueDateTypeCode() {
        return this.vatDueDateTypeCode;
    }

    public Invoice setVATDueDateTypeCode(String vatDueDateTypeCode) {
        this.vatDueDateTypeCode = vatDueDateTypeCode;
        return this;
    }

    @Override
    public String getCreditorReferenceID() {
        return this.creditorReferenceID;
    }

    public Invoice setCreditorReferenceID(String creditorReferenceID) {
        this.creditorReferenceID = creditorReferenceID;
        return this;
    }
}

