/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.mustangproject.ZUGFeRD.IZUGFeRDAllowanceCharge;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableItem;

public class LineCalculator {
    private final BigDecimal price;
    private final BigDecimal priceGross;
    private final BigDecimal itemTotalNetAmount;
    private final BigDecimal itemTotalVATAmount;
    private BigDecimal allowance = BigDecimal.ZERO;
    private BigDecimal charge = BigDecimal.ZERO;
    private BigDecimal allowanceItemTotal = BigDecimal.ZERO;

    public LineCalculator(IZUGFeRDExportableItem currentItem) {
        if (currentItem.getItemAllowances() != null && currentItem.getItemAllowances().length > 0) {
            for (IZUGFeRDAllowanceCharge allowance : currentItem.getItemAllowances()) {
                this.addAllowance(allowance.getTotalAmount(currentItem));
            }
        }
        if (currentItem.getItemCharges() != null && currentItem.getItemCharges().length > 0) {
            for (IZUGFeRDAllowanceCharge charge : currentItem.getItemCharges()) {
                this.addCharge(charge.getTotalAmount(currentItem));
            }
        }
        if (currentItem.getItemTotalAllowances() != null && currentItem.getItemTotalAllowances().length > 0) {
            for (IZUGFeRDAllowanceCharge itemTotalAllowance : currentItem.getItemTotalAllowances()) {
                this.addAllowanceItemTotal(itemTotalAllowance.getTotalAmount(currentItem));
            }
        }
        BigDecimal vatPercent = null;
        if (currentItem.getProduct() != null) {
            vatPercent = currentItem.getProduct().getVATPercent();
        }
        if (vatPercent == null) {
            vatPercent = BigDecimal.ZERO;
        }
        BigDecimal multiplicator = vatPercent.divide(BigDecimal.valueOf(100L));
        this.priceGross = currentItem.getPrice();
        this.price = this.priceGross.subtract(this.allowance).add(this.charge);
        this.itemTotalNetAmount = currentItem.getQuantity().multiply(this.getPrice()).divide(currentItem.getBasisQuantity(), 18, RoundingMode.HALF_UP).subtract(this.allowanceItemTotal).setScale(2, RoundingMode.HALF_UP);
        this.itemTotalVATAmount = this.itemTotalNetAmount.multiply(multiplicator);
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getItemTotalNetAmount() {
        return this.itemTotalNetAmount;
    }

    public BigDecimal getItemTotalVATAmount() {
        return this.itemTotalVATAmount;
    }

    public BigDecimal getItemTotalGrossAmount() {
        return this.itemTotalNetAmount;
    }

    public BigDecimal getPriceGross() {
        return this.priceGross;
    }

    public void addAllowance(BigDecimal b) {
        this.allowance = this.allowance.add(b);
    }

    public void addCharge(BigDecimal b) {
        this.charge = this.charge.add(b);
    }

    public void addAllowanceItemTotal(BigDecimal b) {
        this.allowanceItemTotal = this.allowanceItemTotal.add(b);
    }
}

