/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.mustangproject.Allowance;
import org.mustangproject.BankDetails;
import org.mustangproject.CalculatedInvoice;
import org.mustangproject.Charge;
import org.mustangproject.DirectDebit;
import org.mustangproject.EStandard;
import org.mustangproject.Exceptions.ArithmetricException;
import org.mustangproject.Exceptions.StructureException;
import org.mustangproject.FileAttachment;
import org.mustangproject.IncludedNote;
import org.mustangproject.Invoice;
import org.mustangproject.Item;
import org.mustangproject.TradeParty;
import org.mustangproject.XMLTools;
import org.mustangproject.ZUGFeRD.TransactionCalculator;
import org.mustangproject.ZUGFeRD.ZUGFeRDExportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ZUGFeRDInvoiceImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZUGFeRDInvoiceImporter.class.getCanonicalName());
    protected final HashMap<String, byte[]> additionalXMLs = new HashMap();
    protected final ArrayList<FileAttachment> PDFAttachments = new ArrayList();
    protected boolean containsMeta = false;
    protected byte[] rawXML = null;
    protected String xmpString = null;
    protected Document document;
    protected boolean parseAutomatically = true;
    protected Integer version;
    protected CalculatedInvoice importedInvoice = null;
    protected boolean recalcPrice = false;
    protected boolean ignoreCalculationErrors = false;
    protected ArrayList<FileAttachment> fileAttachments = new ArrayList();

    public ZUGFeRDInvoiceImporter() {
    }

    public ZUGFeRDInvoiceImporter(String pdfFilename) {
        this.setPDFFilename(pdfFilename);
    }

    public ZUGFeRDInvoiceImporter(InputStream pdfStream) {
        this.setInputStream(pdfStream);
    }

    public void setPDFFilename(String pdfFilename) {
        try (InputStream bis = Files.newInputStream(Paths.get(pdfFilename, new String[0]), StandardOpenOption.READ);){
            this.extractLowLevel(bis);
        }
        catch (IOException e) {
            LOGGER.error("Failed to extract ZUGFeRD data", e);
            throw new ZUGFeRDExportException(e);
        }
    }

    public void setInputStream(InputStream pdfStream) {
        try {
            this.extractLowLevel(pdfStream);
        }
        catch (IOException e) {
            LOGGER.error("Failed to extract ZUGFeRD data", e);
            throw new ZUGFeRDExportException(e);
        }
    }

    public List<FileAttachment> getFileAttachmentsPDF() {
        return this.PDFAttachments;
    }

    private void extractLowLevel(InputStream inStream) throws IOException {
        BufferedInputStream pdfStream = new BufferedInputStream(inStream);
        byte[] pad = new byte[4];
        pdfStream.mark(0);
        pdfStream.read(pad);
        pdfStream.reset();
        byte[] pdfSignature = new byte[]{37, 80, 68, 70};
        if (Arrays.equals(pad, pdfSignature)) {
            try {
                PDDocument doc = Loader.loadPDF(IOUtils.toByteArray(pdfStream));
                PDDocumentNameDictionary names = new PDDocumentNameDictionary(doc.getDocumentCatalog());
                if (doc.getDocumentCatalog() == null || doc.getDocumentCatalog().getMetadata() == null) {
                    LOGGER.info("no-xmlpart");
                    return;
                }
                InputStream XMP = doc.getDocumentCatalog().getMetadata().exportXMPMetadata();
                this.xmpString = new String(XMLTools.getBytesFromStream(XMP), StandardCharsets.UTF_8);
                PDEmbeddedFilesNameTreeNode etn = names.getEmbeddedFiles();
                if (etn == null) {
                    return;
                }
                Map<String, PDComplexFileSpecification> efMap = etn.getNames();
                if (efMap != null) {
                    this.extractFiles(efMap);
                }
                List kids = etn.getKids();
                if (kids == null) {
                    return;
                }
                for (PDNameTreeNode node : kids) {
                    Map<String, PDComplexFileSpecification> namesL = node.getNames();
                    this.extractFiles(namesL);
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to parse PDF", e);
            }
        } else {
            this.containsMeta = true;
            this.setRawXML(XMLTools.getBytesFromStream(pdfStream));
        }
    }

    public void doRecalculateItemPricesFromLineTotals() {
        this.recalcPrice = true;
    }

    public void doIgnoreCalculationErrors() {
        this.ignoreCalculationErrors = true;
    }

    private void extractFiles(Map<String, PDComplexFileSpecification> names) throws IOException {
        for (String alias : names.keySet()) {
            PDComplexFileSpecification fileSpec = names.get(alias);
            String filename = fileSpec.getFilename();
            PDEmbeddedFile embeddedFile = fileSpec.getEmbeddedFile();
            if (filename.equals("ZUGFeRD-invoice.xml") || filename.equals("zugferd-invoice.xml") || filename.equals("factur-x.xml") || filename.equals("xrechnung.xml") || filename.equals("order-x.xml") || filename.equals("cida.xml")) {
                this.containsMeta = true;
                this.setRawXML(embeddedFile.toByteArray());
            }
            if (filename.startsWith("additional_data")) {
                this.additionalXMLs.put(filename, embeddedFile.toByteArray());
            }
            this.PDFAttachments.add(new FileAttachment(filename, embeddedFile.getSubtype(), "Data", embeddedFile.toByteArray()));
        }
    }

    public void setRawXML(byte[] rawXML, boolean doParse) throws IOException {
        this.containsMeta = true;
        this.rawXML = rawXML;
        this.version = null;
        this.parseAutomatically = doParse;
        try {
            this.setDocument();
        }
        catch (ParserConfigurationException | SAXException e) {
            LOGGER.error("Failed to parse XML", e);
            throw new ZUGFeRDExportException(e);
        }
    }

    public void setRawXML(byte[] rawXML) throws IOException {
        this.setRawXML(rawXML, true);
    }

    private void setDocument() throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory xmlFact = DocumentBuilderFactory.newInstance();
        xmlFact.setNamespaceAware(true);
        DocumentBuilder builder = xmlFact.newDocumentBuilder();
        ByteArrayInputStream is = new ByteArrayInputStream(this.rawXML);
        this.document = builder.parse(is);
        if (this.parseAutomatically) {
            try {
                this.importedInvoice = new CalculatedInvoice();
                this.extractInto(this.importedInvoice);
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException(e);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Invoice extractInto(Invoice zpp) throws XPathExpressionException, ParseException {
        NodeList nodes;
        NodeList prepaidNodes;
        String number = "";
        String typeCode = null;
        String deliveryPeriodStart = null;
        String deliveryPeriodEnd = null;
        XPathFactory xpathFact = XPathFactory.newInstance();
        XPath xpath = xpathFact.newXPath();
        XPathExpression xpr = xpath.compile("//*[local-name()=\"SellerTradeParty\"]|//*[local-name()=\"AccountingSupplierParty\"]/*");
        NodeList SellerNodes = (NodeList)xpr.evaluate(this.getDocument(), XPathConstants.NODESET);
        XPathExpression shipEx = xpath.compile("//*[local-name()=\"ShipToTradeParty\"]");
        NodeList deliveryNodes = (NodeList)shipEx.evaluate(this.getDocument(), XPathConstants.NODESET);
        if (deliveryNodes != null) {
            zpp.setDeliveryAddress(new TradeParty(deliveryNodes));
        }
        xpr = xpath.compile("//*[local-name()=\"BuyerTradeParty\"]|//*[local-name()=\"AccountingCustomerParty\"]/*");
        NodeList BuyerNodes = (NodeList)xpr.evaluate(this.getDocument(), XPathConstants.NODESET);
        xpr = xpath.compile("//*[local-name()=\"PayeeTradeParty\"]|//*[local-name()=\"PayeeParty\"]/*");
        NodeList payeeNodes = (NodeList)xpr.evaluate(this.getDocument(), XPathConstants.NODESET);
        xpr = xpath.compile("//*[local-name()=\"ExchangedDocument\"]|//*[local-name()=\"HeaderExchangedDocument\"]");
        NodeList ExchangedDocumentNodes = (NodeList)xpr.evaluate(this.getDocument(), XPathConstants.NODESET);
        xpr = xpath.compile("//*[local-name()=\"GrandTotalAmount\"]|//*[local-name()=\"PayableAmount\"]");
        BigDecimal expectedGrandTotal = null;
        NodeList totalNodes = (NodeList)xpr.evaluate(this.getDocument(), XPathConstants.NODESET);
        if (totalNodes.getLength() > 0) {
            expectedGrandTotal = new BigDecimal(XMLTools.trimOrNull(totalNodes.item(0)));
            if (zpp instanceof CalculatedInvoice) {
                ((CalculatedInvoice)zpp).setGrandTotal(expectedGrandTotal);
            }
        }
        if ((prepaidNodes = (NodeList)(xpr = xpath.compile("//*[local-name()=\"PrepaidAmount\"]")).evaluate(this.getDocument(), XPathConstants.NODESET)).getLength() > 0) {
            zpp.setTotalPrepaidAmount(new BigDecimal(XMLTools.trimOrNull(prepaidNodes.item(0))));
        }
        Date issueDate = null;
        Date dueDate = null;
        Date deliveryDate = null;
        String despatchAdviceReferencedDocument = null;
        for (int i = 0; i < ExchangedDocumentNodes.getLength(); ++i) {
            Node exchangedDocumentNode = ExchangedDocumentNodes.item(i);
            NodeList exchangedDocumentChilds = exchangedDocumentNode.getChildNodes();
            for (int documentChildIndex = 0; documentChildIndex < exchangedDocumentChilds.getLength(); ++documentChildIndex) {
                Node item = exchangedDocumentChilds.item(documentChildIndex);
                if (item.getLocalName() != null && item.getLocalName().equals("ID")) {
                    number = XMLTools.trimOrNull(item);
                }
                if (item.getLocalName() != null && item.getLocalName().equals("TypeCode")) {
                    typeCode = XMLTools.trimOrNull(item);
                }
                if (item.getLocalName() != null && item.getLocalName().equals("IssueDateTime")) {
                    NodeList issueDateTimeChilds = item.getChildNodes();
                    for (int issueDateChildIndex = 0; issueDateChildIndex < issueDateTimeChilds.getLength(); ++issueDateChildIndex) {
                        if (issueDateTimeChilds.item(issueDateChildIndex).getLocalName() == null || !issueDateTimeChilds.item(issueDateChildIndex).getLocalName().equals("DateTimeString")) continue;
                        issueDate = new SimpleDateFormat("yyyyMMdd").parse(XMLTools.trimOrNull(issueDateTimeChilds.item(issueDateChildIndex)));
                    }
                }
                ArrayList<IncludedNote> includedNotes = new ArrayList<IncludedNote>();
                if (item.getLocalName() != null && item.getLocalName().equals("IncludedNote")) {
                    String subjectCode = "";
                    String content = null;
                    NodeList includedNodeChilds = item.getChildNodes();
                    for (int issueDateChildIndex = 0; issueDateChildIndex < includedNodeChilds.getLength(); ++issueDateChildIndex) {
                        if (includedNodeChilds.item(issueDateChildIndex).getLocalName() != null && includedNodeChilds.item(issueDateChildIndex).getLocalName().equals("Content")) {
                            content = XMLTools.trimOrNull(includedNodeChilds.item(issueDateChildIndex));
                        }
                        if (includedNodeChilds.item(issueDateChildIndex).getLocalName() == null || !includedNodeChilds.item(issueDateChildIndex).getLocalName().equals("SubjectCode")) continue;
                        subjectCode = XMLTools.trimOrNull(includedNodeChilds.item(issueDateChildIndex));
                    }
                    switch (subjectCode) {
                        case "AAI": {
                            includedNotes.add(IncludedNote.generalNote(content));
                            break;
                        }
                        case "REG": {
                            includedNotes.add(IncludedNote.regulatoryNote(content));
                            break;
                        }
                        case "ABL": {
                            includedNotes.add(IncludedNote.legalNote(content));
                            break;
                        }
                        case "CUS": {
                            includedNotes.add(IncludedNote.customsNote(content));
                            break;
                        }
                        case "SUR": {
                            includedNotes.add(IncludedNote.sellerNote(content));
                            break;
                        }
                        case "TXD": {
                            includedNotes.add(IncludedNote.taxNote(content));
                            break;
                        }
                        case "ACY": {
                            includedNotes.add(IncludedNote.introductionNote(content));
                            break;
                        }
                        case "AAK": {
                            includedNotes.add(IncludedNote.discountBonusNote(content));
                            break;
                        }
                        default: {
                            includedNotes.add(IncludedNote.unspecifiedNote(content));
                        }
                    }
                }
                zpp.addNotes(includedNotes);
            }
        }
        String rootNode = this.extractString("local-name(/*)");
        if (rootNode.equals("Invoice")) {
            String deliveryDt;
            number = this.extractString("//*[local-name()=\"Invoice\"]/*[local-name()=\"ID\"]").trim();
            typeCode = this.extractString("//*[local-name()=\"Invoice\"]/*[local-name()=\"InvoiceTypeCode\"]").trim();
            issueDate = new SimpleDateFormat("yyyy-MM-dd").parse(this.extractString("//*[local-name()=\"Invoice\"]/*[local-name()=\"IssueDate\"]").trim());
            String dueDt = this.extractString("//*[local-name()=\"Invoice\"]/*[local-name()=\"DueDate\"]").trim();
            if (dueDt.length() > 0) {
                dueDate = new SimpleDateFormat("yyyy-MM-dd").parse(dueDt);
            }
            if ((deliveryDt = this.extractString("//*[local-name()=\"Delivery\"]/*[local-name()=\"ActualDeliveryDate\"]").trim()).length() > 0) {
                deliveryDate = new SimpleDateFormat("yyyy-MM-dd").parse(deliveryDt);
            }
        }
        xpr = xpath.compile("//*[local-name()=\"ApplicableHeaderTradeDelivery\"]");
        NodeList headerTradeDeliveryNodes = (NodeList)xpr.evaluate(this.getDocument(), XPathConstants.NODESET);
        for (int i = 0; i < headerTradeDeliveryNodes.getLength(); ++i) {
            Node headerTradeDeliveryNode = headerTradeDeliveryNodes.item(i);
            NodeList headerTradeDeliveryChilds = headerTradeDeliveryNode.getChildNodes();
            for (int deliveryChildIndex = 0; deliveryChildIndex < headerTradeDeliveryChilds.getLength(); ++deliveryChildIndex) {
                if (headerTradeDeliveryChilds.item(deliveryChildIndex).getLocalName() == null) continue;
                if (headerTradeDeliveryChilds.item(deliveryChildIndex).getLocalName().equals("ActualDeliverySupplyChainEvent")) {
                    NodeList actualDeliveryChilds = headerTradeDeliveryChilds.item(deliveryChildIndex).getChildNodes();
                    for (int actualDeliveryChildIndex = 0; actualDeliveryChildIndex < actualDeliveryChilds.getLength(); ++actualDeliveryChildIndex) {
                        if (actualDeliveryChilds.item(actualDeliveryChildIndex).getLocalName() == null || !actualDeliveryChilds.item(actualDeliveryChildIndex).getLocalName().equals("OccurrenceDateTime")) continue;
                        NodeList occurenceChilds = actualDeliveryChilds.item(actualDeliveryChildIndex).getChildNodes();
                        for (int occurenceChildIndex = 0; occurenceChildIndex < occurenceChilds.getLength(); ++occurenceChildIndex) {
                            if (occurenceChilds.item(occurenceChildIndex).getLocalName() == null || !occurenceChilds.item(occurenceChildIndex).getLocalName().equals("DateTimeString")) continue;
                            deliveryDate = new SimpleDateFormat("yyyyMMdd").parse(XMLTools.trimOrNull(occurenceChilds.item(occurenceChildIndex)));
                        }
                    }
                }
                if (!headerTradeDeliveryChilds.item(deliveryChildIndex).getLocalName().equals("DespatchAdviceReferencedDocument")) continue;
                NodeList despatchAdviceChilds = headerTradeDeliveryChilds.item(deliveryChildIndex).getChildNodes();
                for (int despatchAdviceChildIndex = 0; despatchAdviceChildIndex < despatchAdviceChilds.getLength(); ++despatchAdviceChildIndex) {
                    if (despatchAdviceChilds.item(despatchAdviceChildIndex).getLocalName() == null || !despatchAdviceChilds.item(despatchAdviceChildIndex).getLocalName().equals("IssuerAssignedID")) continue;
                    despatchAdviceReferencedDocument = XMLTools.trimOrNull(despatchAdviceChilds.item(despatchAdviceChildIndex));
                }
            }
        }
        xpr = xpath.compile("//*[local-name()=\"ApplicableHeaderTradeAgreement\"]");
        NodeList headerTradeAgreementNodes = (NodeList)xpr.evaluate(this.getDocument(), XPathConstants.NODESET);
        String buyerOrderIssuerAssignedID = null;
        String sellerOrderIssuerAssignedID = null;
        for (int i = 0; i < headerTradeAgreementNodes.getLength(); ++i) {
            Node headerTradeAgreementNode = headerTradeAgreementNodes.item(i);
            NodeList headerTradeAgreementChilds = headerTradeAgreementNode.getChildNodes();
            for (int agreementChildIndex = 0; agreementChildIndex < headerTradeAgreementChilds.getLength(); ++agreementChildIndex) {
                if (headerTradeAgreementChilds.item(agreementChildIndex).getLocalName() == null) continue;
                if (headerTradeAgreementChilds.item(agreementChildIndex).getLocalName().equals("BuyerOrderReferencedDocument")) {
                    NodeList buyerOrderChilds = headerTradeAgreementChilds.item(agreementChildIndex).getChildNodes();
                    for (int buyerOrderChildIndex = 0; buyerOrderChildIndex < buyerOrderChilds.getLength(); ++buyerOrderChildIndex) {
                        if (buyerOrderChilds.item(buyerOrderChildIndex).getLocalName() == null || !buyerOrderChilds.item(buyerOrderChildIndex).getLocalName().equals("IssuerAssignedID")) continue;
                        buyerOrderIssuerAssignedID = XMLTools.trimOrNull(buyerOrderChilds.item(buyerOrderChildIndex));
                    }
                }
                if (!headerTradeAgreementChilds.item(agreementChildIndex).getLocalName().equals("SellerOrderReferencedDocument")) continue;
                NodeList sellerOrderChilds = headerTradeAgreementChilds.item(agreementChildIndex).getChildNodes();
                for (int sellerOrderChildIndex = 0; sellerOrderChildIndex < sellerOrderChilds.getLength(); ++sellerOrderChildIndex) {
                    if (sellerOrderChilds.item(sellerOrderChildIndex).getLocalName() == null || !sellerOrderChilds.item(sellerOrderChildIndex).getLocalName().equals("IssuerAssignedID")) continue;
                    sellerOrderIssuerAssignedID = XMLTools.trimOrNull(sellerOrderChilds.item(sellerOrderChildIndex));
                }
            }
        }
        String currency = this.extractString("//*[local-name()=\"ApplicableHeaderTradeSettlement\"]/*[local-name()=\"InvoiceCurrencyCode\"]|//*[local-name()=\"DocumentCurrencyCode\"]");
        zpp.setCurrency(currency);
        xpr = xpath.compile("//*[local-name()=\"ApplicableHeaderTradeSettlement\"]|//*[local-name()=\"ApplicableSupplyChainTradeSettlement\"]");
        NodeList headerTradeSettlementNodes = (NodeList)xpr.evaluate(this.getDocument(), XPathConstants.NODESET);
        ArrayList<BankDetails> bankDetails = new ArrayList<BankDetails>();
        String directDebitMandateID = null;
        String IBAN = null;
        String BIC = null;
        for (int i = 0; i < headerTradeSettlementNodes.getLength(); ++i) {
            Node headerTradeSettlementNode = headerTradeSettlementNodes.item(i);
            NodeList headerTradeSettlementChilds = headerTradeSettlementNode.getChildNodes();
            for (int settlementChildIndex = 0; settlementChildIndex < headerTradeSettlementChilds.getLength(); ++settlementChildIndex) {
                if (headerTradeSettlementChilds.item(settlementChildIndex).getLocalName() != null && headerTradeSettlementChilds.item(settlementChildIndex).getLocalName().equals("SpecifiedTradePaymentTerms")) {
                    NodeList paymentTermChilds = headerTradeSettlementChilds.item(settlementChildIndex).getChildNodes();
                    for (int paymentTermChildIndex = 0; paymentTermChildIndex < paymentTermChilds.getLength(); ++paymentTermChildIndex) {
                        if (paymentTermChilds.item(paymentTermChildIndex).getLocalName() != null && paymentTermChilds.item(paymentTermChildIndex).getLocalName().equals("DueDateDateTime")) {
                            NodeList dueDateChilds = paymentTermChilds.item(paymentTermChildIndex).getChildNodes();
                            for (int dueDateChildIndex = 0; dueDateChildIndex < dueDateChilds.getLength(); ++dueDateChildIndex) {
                                if (dueDateChilds.item(dueDateChildIndex).getLocalName() == null || !dueDateChilds.item(dueDateChildIndex).getLocalName().equals("DateTimeString")) continue;
                                dueDate = new SimpleDateFormat("yyyyMMdd").parse(XMLTools.trimOrNull(dueDateChilds.item(dueDateChildIndex)));
                            }
                        }
                        if (paymentTermChilds.item(paymentTermChildIndex).getLocalName() == null || !paymentTermChilds.item(paymentTermChildIndex).getLocalName().equals("DirectDebitMandateID")) continue;
                        directDebitMandateID = paymentTermChilds.item(paymentTermChildIndex).getTextContent();
                    }
                }
                if (headerTradeSettlementChilds.item(settlementChildIndex).getLocalName() != null && headerTradeSettlementChilds.item(settlementChildIndex).getLocalName().equals("SpecifiedTradeSettlementPaymentMeans")) {
                    NodeList paymentMeansChilds = headerTradeSettlementChilds.item(settlementChildIndex).getChildNodes();
                    IBAN = null;
                    BIC = null;
                    for (int paymentMeansChildIndex = 0; paymentMeansChildIndex < paymentMeansChilds.getLength(); ++paymentMeansChildIndex) {
                        int accountChildIndex;
                        NodeList accountChilds;
                        if (paymentMeansChilds.item(paymentMeansChildIndex).getLocalName() != null && (paymentMeansChilds.item(paymentMeansChildIndex).getLocalName().equals("PayeePartyCreditorFinancialAccount") || paymentMeansChilds.item(paymentMeansChildIndex).getLocalName().equals("PayerPartyDebtorFinancialAccount"))) {
                            accountChilds = paymentMeansChilds.item(paymentMeansChildIndex).getChildNodes();
                            for (accountChildIndex = 0; accountChildIndex < accountChilds.getLength(); ++accountChildIndex) {
                                if (accountChilds.item(accountChildIndex).getLocalName() == null || !accountChilds.item(accountChildIndex).getLocalName().equals("IBANID")) continue;
                                IBAN = XMLTools.trimOrNull(accountChilds.item(accountChildIndex));
                            }
                        }
                        if (paymentMeansChilds.item(paymentMeansChildIndex).getLocalName() == null || !paymentMeansChilds.item(paymentMeansChildIndex).getLocalName().equals("PayeeSpecifiedCreditorFinancialInstitution")) continue;
                        accountChilds = paymentMeansChilds.item(paymentMeansChildIndex).getChildNodes();
                        for (accountChildIndex = 0; accountChildIndex < accountChilds.getLength(); ++accountChildIndex) {
                            if (accountChilds.item(accountChildIndex).getLocalName() == null || !accountChilds.item(accountChildIndex).getLocalName().equals("BICID")) continue;
                            BIC = XMLTools.trimOrNull(accountChilds.item(accountChildIndex));
                        }
                    }
                    if (IBAN != null) {
                        BankDetails bd = new BankDetails(IBAN);
                        if (BIC != null) {
                            bd.setBIC(BIC);
                        }
                        bankDetails.add(bd);
                    }
                }
                if (headerTradeSettlementChilds.item(settlementChildIndex).getLocalName() == null || !headerTradeSettlementChilds.item(settlementChildIndex).getLocalName().equals("BillingSpecifiedPeriod")) continue;
                NodeList periodChilds = headerTradeSettlementChilds.item(settlementChildIndex).getChildNodes();
                for (int periodChildIndex = 0; periodChildIndex < periodChilds.getLength(); ++periodChildIndex) {
                    if (periodChilds.item(periodChildIndex).getLocalName() != null && periodChilds.item(periodChildIndex).getLocalName().equals("StartDateTime")) {
                        NodeList startPeriodChilds = periodChilds.item(periodChildIndex).getChildNodes();
                        for (int startPeriodIndex = 0; startPeriodIndex < startPeriodChilds.getLength(); ++startPeriodIndex) {
                            if (startPeriodChilds.item(startPeriodIndex).getLocalName() == null || !startPeriodChilds.item(startPeriodIndex).getLocalName().equals("DateTimeString")) continue;
                            deliveryPeriodStart = XMLTools.trimOrNull(startPeriodChilds.item(startPeriodIndex));
                        }
                    }
                    if (periodChilds.item(periodChildIndex).getLocalName() == null || !periodChilds.item(periodChildIndex).getLocalName().equals("EndDateTime")) continue;
                    NodeList endPeriodChilds = periodChilds.item(periodChildIndex).getChildNodes();
                    for (int endPeriodIndex = 0; endPeriodIndex < endPeriodChilds.getLength(); ++endPeriodIndex) {
                        if (endPeriodChilds.item(endPeriodIndex).getLocalName() == null || !endPeriodChilds.item(endPeriodIndex).getLocalName().equals("DateTimeString")) continue;
                        deliveryPeriodEnd = XMLTools.trimOrNull(endPeriodChilds.item(endPeriodIndex));
                    }
                }
            }
        }
        if (deliveryPeriodStart != null && deliveryPeriodEnd != null) {
            zpp.setDetailedDeliveryPeriod(XMLTools.tryDate(deliveryPeriodStart), XMLTools.tryDate(deliveryPeriodEnd));
        } else if (deliveryPeriodStart != null) {
            zpp.setDeliveryDate(XMLTools.tryDate(deliveryPeriodStart));
        }
        xpr = xpath.compile("//*[local-name()=\"PaymentMeans\"]");
        NodeList paymentMeansNodes = (NodeList)xpr.evaluate(this.getDocument(), XPathConstants.NODESET);
        for (int i = 0; i < paymentMeansNodes.getLength(); ++i) {
            Node paymentMeansNode = paymentMeansNodes.item(i);
            NodeList paymentMeansChilds = paymentMeansNode.getChildNodes();
            for (int meansChildIndex = 0; meansChildIndex < paymentMeansChilds.getLength(); ++meansChildIndex) {
                if (paymentMeansChilds.item(meansChildIndex).getLocalName() == null || !paymentMeansChilds.item(meansChildIndex).getLocalName().equals("PayeeFinancialAccount")) continue;
                NodeList paymentTermChilds = paymentMeansChilds.item(meansChildIndex).getChildNodes();
                for (int paymentTermChildIndex = 0; paymentTermChildIndex < paymentTermChilds.getLength(); ++paymentTermChildIndex) {
                    if (paymentTermChilds.item(paymentTermChildIndex).getLocalName() == null || !paymentTermChilds.item(paymentTermChildIndex).getLocalName().equals("ID") || (IBAN = XMLTools.trimOrNull(paymentTermChilds.item(paymentTermChildIndex))) == null) continue;
                    BankDetails bd = new BankDetails(IBAN);
                    bankDetails.add(bd);
                }
            }
        }
        zpp.setDueDate(dueDate).setDeliveryDate(deliveryDate).setIssueDate(issueDate).setSender(new TradeParty(SellerNodes)).setRecipient(new TradeParty(BuyerNodes)).setNumber(number).setDocumentCode(typeCode);
        if (directDebitMandateID != null && IBAN != null) {
            DirectDebit d = new DirectDebit(IBAN, directDebitMandateID);
            zpp.getSender().addDebitDetails(d);
        }
        bankDetails.forEach(bankDetail -> zpp.getSender().addBankDetails((BankDetails)bankDetail));
        if (payeeNodes.getLength() > 0) {
            zpp.setPayee(new TradeParty(payeeNodes));
        }
        if (buyerOrderIssuerAssignedID != null) {
            zpp.setBuyerOrderReferencedDocumentID(buyerOrderIssuerAssignedID);
        } else {
            zpp.setBuyerOrderReferencedDocumentID(this.extractString("//*[local-name()=\"OrderReference\"]/*[local-name()=\"ID\"]"));
        }
        if (sellerOrderIssuerAssignedID != null) {
            zpp.setSellerOrderReferencedDocumentID(sellerOrderIssuerAssignedID);
        }
        if (despatchAdviceReferencedDocument != null) {
            zpp.setDespatchAdviceReferencedDocumentID(despatchAdviceReferencedDocument);
        }
        zpp.setOwnOrganisationName(this.extractString("//*[local-name()=\"SellerTradeParty\"]/*[local-name()=\"Name\"]|//*[local-name()=\"AccountingSupplierParty\"]/*[local-name()=\"Party\"]/*[local-name()=\"PartyName\"]").trim());
        String rounding = this.extractString("//*[local-name()=\"SpecifiedTradeSettlementHeaderMonetarySummation\"]/*[local-name()=\"RoundingAmount\"]|//*[local-name()=\"LegalMonetaryTotal\"]/*[local-name()=\"Party\"]/*[local-name()=\"PayableRoundingAmount\"]");
        if (rounding != null && !rounding.isEmpty()) {
            zpp.setRoundingAmount(new BigDecimal(rounding.trim()));
        }
        xpr = xpath.compile("//*[local-name()=\"BuyerReference\"]");
        String buyerReference = null;
        prepaidNodes = (NodeList)xpr.evaluate(this.getDocument(), XPathConstants.NODESET);
        if (prepaidNodes.getLength() > 0) {
            buyerReference = XMLTools.trimOrNull(prepaidNodes.item(0));
        }
        if (buyerReference != null) {
            zpp.setReferenceNumber(buyerReference);
        }
        if ((nodes = (NodeList)(xpr = xpath.compile("//*[local-name()=\"IncludedSupplyChainTradeLineItem\"]|//*[local-name()=\"InvoiceLine\"]")).evaluate(this.getDocument(), XPathConstants.NODESET)).getLength() != 0) {
            EStandard whichType;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node currentItemNode = nodes.item(i);
                Item it = new Item(currentItemNode.getChildNodes(), this.recalcPrice);
                zpp.addItem(it);
            }
            xpr = xpath.compile("//*[local-name()=\"AttachmentBinaryObject\"]|//*[local-name()=\"EmbeddedDocumentBinaryObject\"]");
            NodeList attachmentNodes = (NodeList)xpr.evaluate(this.getDocument(), XPathConstants.NODESET);
            for (int i = 0; i < attachmentNodes.getLength(); ++i) {
                FileAttachment fa = new FileAttachment(attachmentNodes.item(i).getAttributes().getNamedItem("filename").getNodeValue(), attachmentNodes.item(i).getAttributes().getNamedItem("mimeCode").getNodeValue(), "Data", Base64.getDecoder().decode(XMLTools.trimOrNull(attachmentNodes.item(i))));
                this.fileAttachments.add(fa);
            }
            xpr = xpath.compile("//*[local-name()=\"SpecifiedTradeAllowanceCharge\"]");
            NodeList chargeNodes = (NodeList)xpr.evaluate(this.getDocument(), XPathConstants.NODESET);
            for (int i = 0; i < chargeNodes.getLength(); ++i) {
                NodeList chargeNodeChilds = chargeNodes.item(i).getChildNodes();
                boolean isCharge = true;
                String chargeAmount = null;
                String reason = null;
                String reasonCode = null;
                String taxPercent = null;
                for (int chargeChildIndex = 0; chargeChildIndex < chargeNodeChilds.getLength(); ++chargeChildIndex) {
                    String chargeChildName = chargeNodeChilds.item(chargeChildIndex).getLocalName();
                    if (chargeChildName == null) continue;
                    if (chargeChildName.equals("ChargeIndicator")) {
                        NodeList indicatorChilds = chargeNodeChilds.item(chargeChildIndex).getChildNodes();
                        for (int indicatorChildIndex = 0; indicatorChildIndex < indicatorChilds.getLength(); ++indicatorChildIndex) {
                            if (indicatorChilds.item(indicatorChildIndex).getLocalName() == null || !indicatorChilds.item(indicatorChildIndex).getLocalName().equals("Indicator")) continue;
                            isCharge = XMLTools.trimOrNull(indicatorChilds.item(indicatorChildIndex)).equalsIgnoreCase("true");
                        }
                        continue;
                    }
                    if (chargeChildName.equals("ActualAmount")) {
                        chargeAmount = XMLTools.trimOrNull(chargeNodeChilds.item(chargeChildIndex));
                        continue;
                    }
                    if (chargeChildName.equals("Reason")) {
                        reason = XMLTools.trimOrNull(chargeNodeChilds.item(chargeChildIndex));
                        continue;
                    }
                    if (chargeChildName.equals("ReasonCode")) {
                        reasonCode = XMLTools.trimOrNull(chargeNodeChilds.item(chargeChildIndex));
                        continue;
                    }
                    if (!chargeChildName.equals("CategoryTradeTax")) continue;
                    NodeList taxChilds = chargeNodeChilds.item(chargeChildIndex).getChildNodes();
                    for (int taxChildIndex = 0; taxChildIndex < taxChilds.getLength(); ++taxChildIndex) {
                        String taxItemName = taxChilds.item(taxChildIndex).getLocalName();
                        if (taxItemName == null || !taxItemName.equals("RateApplicablePercent") && !taxItemName.equals("ApplicablePercent")) continue;
                        taxPercent = XMLTools.trimOrNull(taxChilds.item(taxChildIndex));
                    }
                }
                if (isCharge) {
                    Charge c = new Charge(new BigDecimal(chargeAmount));
                    if (reason != null) {
                        c.setReason(reason);
                    }
                    if (reasonCode != null) {
                        c.setReasonCode(reasonCode);
                    }
                    if (taxPercent != null) {
                        c.setTaxPercent(new BigDecimal(taxPercent));
                    }
                    zpp.addCharge(c);
                    continue;
                }
                Allowance a = new Allowance(new BigDecimal(chargeAmount));
                if (reason != null) {
                    a.setReason(reason);
                }
                if (reasonCode != null) {
                    a.setReasonCode(reasonCode);
                }
                if (taxPercent != null) {
                    a.setTaxPercent(new BigDecimal(taxPercent));
                }
                zpp.addAllowance(a);
            }
            TransactionCalculator tc = new TransactionCalculator(zpp);
            String expectedStringTotalGross = tc.getGrandTotal().subtract(Objects.requireNonNullElse(zpp.getTotalPrepaidAmount(), BigDecimal.ZERO)).toPlainString();
            try {
                whichType = this.getStandard();
            }
            catch (Exception e) {
                throw new StructureException("Could not find out if it's an invoice, order, or delivery advice", 0);
            }
            if (whichType != EStandard.despatchadvice && !expectedStringTotalGross.equals(XMLTools.nDigitFormat(expectedGrandTotal, 2)) && !this.ignoreCalculationErrors) {
                throw new ArithmetricException();
            }
        }
        return zpp;
    }

    protected Document getDocument() {
        return this.document;
    }

    protected String extractString(String xpathStr) {
        String result;
        if (!this.containsMeta) {
            throw new ZUGFeRDExportException("No suitable data/ZUGFeRD file could be found.");
        }
        try {
            Document document = this.getDocument();
            XPathFactory xpathFact = XPathFactory.newInstance();
            XPath xpath = xpathFact.newXPath();
            result = xpath.evaluate(xpathStr, document);
        }
        catch (XPathExpressionException e) {
            LOGGER.error("Failed to evaluate XPath", e);
            throw new ZUGFeRDExportException(e);
        }
        return result;
    }

    public EStandard getStandard() throws Exception {
        if (!this.containsMeta) {
            throw new Exception("Not yet parsed");
        }
        String head = this.getUTF8();
        String rootNode = this.extractString("local-name(/*)");
        if (rootNode.equals("CrossIndustryDocument")) {
            return EStandard.zugferd;
        }
        if (rootNode.equals("Invoice")) {
            return EStandard.ubl;
        }
        if (rootNode.equals("CreditNote")) {
            return EStandard.ubl;
        }
        if (rootNode.equals("CrossIndustryInvoice")) {
            return EStandard.facturx;
        }
        if (rootNode.equals("SCRDMCCBDACIDAMessageStructure")) {
            return EStandard.despatchadvice;
        }
        if (head.contains("<rsm:SCRDMCCBDACIOMessageStructure")) {
            return EStandard.orderx;
        }
        throw new Exception("ZUGFeRD version could not be determined");
    }

    public String getUTF8() {
        byte[] bomlessData;
        if (this.rawXML == null) {
            return null;
        }
        if (this.rawXML.length < 3) {
            return new String(this.rawXML);
        }
        if (this.rawXML[0] == -17 && this.rawXML[1] == -69 && this.rawXML[2] == -65) {
            bomlessData = new byte[this.rawXML.length - 3];
            System.arraycopy(this.rawXML, 3, bomlessData, 0, this.rawXML.length - 3);
        } else {
            bomlessData = this.rawXML;
        }
        return new String(bomlessData);
    }

    public List<FileAttachment> getFileAttachmentsXML() {
        return this.fileAttachments;
    }

    public Invoice extractInvoice() throws XPathExpressionException, ParseException {
        Invoice i = new Invoice();
        return this.extractInto(i);
    }

    public void fromXML(String XML2) {
        try {
            this.containsMeta = true;
            this.setRawXML(XML2.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), e);
        }
    }
}

