/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import com.helger.commons.io.stream.StreamHelper;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.fop.apps.io.ResourceResolverFactory;
import org.apache.fop.configuration.ConfigurationException;
import org.apache.fop.configuration.DefaultConfiguration;
import org.apache.fop.configuration.DefaultConfigurationBuilder;
import org.mustangproject.ClasspathResolverURIAdapter;
import org.mustangproject.EStandard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ZUGFeRDVisualizer {
    static final ClassLoader CLASS_LOADER = ZUGFeRDVisualizer.class.getClassLoader();
    private static final String RESOURCE_PATH = "";
    private static final Logger LOGGER = LoggerFactory.getLogger(ZUGFeRDVisualizer.class);
    private TransformerFactory mFactory = new TransformerFactoryImpl();
    private Templates mXsltXRTemplate = null;
    private Templates mXsltUBLTemplate = null;
    private Templates mXsltCIOTemplate = null;
    private Templates mXsltHTMLTemplate = null;
    private Templates mXsltPDFTemplate = null;
    private Templates mXsltZF1HTMLTemplate = null;

    public ZUGFeRDVisualizer() {
        this.mFactory.setURIResolver(new ClasspathResourceURIResolver());
    }

    public EStandard findOutStandardFromRootNode(InputStream fis) {
        String zf1Signature = "CrossIndustryDocument";
        String zf2Signature = "CrossIndustryInvoice";
        String ublSignature = "Invoice";
        String ublCreditNoteSignature = "CreditNote";
        String cioSignature = "SCRDMCCBDACIOMessageStructure";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(fis));
            Element root = doc.getDocumentElement();
            if (root.getLocalName().equals(zf1Signature)) {
                return EStandard.zugferd;
            }
            if (root.getLocalName().equals(zf2Signature)) {
                return EStandard.facturx;
            }
            if (root.getLocalName().equals(ublSignature)) {
                return EStandard.ubl;
            }
            if (root.getLocalName().equals(ublCreditNoteSignature)) {
                return EStandard.ubl_creditnote;
            }
            if (root.getLocalName().equals(cioSignature)) {
                return EStandard.orderx;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to recognize standard", e);
        }
        return null;
    }

    public String visualize(String xmlFilename, Language lang) throws FileNotFoundException, TransformerException, IOException, SAXException, ParserConfigurationException {
        try {
            if (this.mXsltPDFTemplate == null) {
                this.mXsltPDFTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/xr-pdf.xsl")));
            }
            if (this.mXsltHTMLTemplate == null) {
                this.mXsltHTMLTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/xrechnung-html." + lang.name().toLowerCase() + ".xsl")));
            }
            if (this.mXsltZF1HTMLTemplate == null) {
                this.mXsltZF1HTMLTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/ZUGFeRD_1p0_c1p0_s1p0.xslt")));
            }
        }
        catch (TransformerConfigurationException ex) {
            LOGGER.error("Failed to init XSLT templates", ex);
        }
        FileInputStream fis = new FileInputStream(xmlFilename);
        String fileContent = RESOURCE_PATH;
        try {
            fileContent = new String(Files.readAllBytes(Paths.get(xmlFilename, new String[0])), StandardCharsets.UTF_8);
        }
        catch (IOException e2) {
            LOGGER.error("Failed to read file content", e2);
        }
        final ByteArrayOutputStream iaos = new ByteArrayOutputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean doPostProcessing = false;
        fis = new FileInputStream(xmlFilename);
        EStandard thestandard = this.findOutStandardFromRootNode(fis);
        fis = new FileInputStream(xmlFilename);
        if (thestandard == EStandard.zugferd) {
            this.applyZF1XSLT(fis, baos);
        } else if (thestandard == EStandard.facturx) {
            this.applyZF2XSLT(fis, iaos);
            doPostProcessing = true;
        } else if (thestandard == EStandard.ubl) {
            this.applyUBL2XSLT(fis, iaos);
            doPostProcessing = true;
        } else if (thestandard == EStandard.ubl_creditnote) {
            this.applyUBLCreditNote2XSLT(fis, iaos);
            doPostProcessing = true;
        } else if (thestandard == EStandard.orderx) {
            this.applyCIO2XSLT(fis, iaos);
            doPostProcessing = true;
        } else {
            throw new IllegalArgumentException("File does not look like CII or UBL");
        }
        if (doPostProcessing) {
            PipedInputStream in = new PipedInputStream();
            try {
                final PipedOutputStream out = new PipedOutputStream(in);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            iaos.writeTo(out);
                        }
                        catch (IOException e) {
                            LOGGER.error("Failed to write to stream", e);
                        }
                        finally {
                            StreamHelper.close(out);
                        }
                    }
                }).start();
                this.applyXSLTToHTML(in, baos);
            }
            catch (IOException e1) {
                LOGGER.error("Failed to create HTML", e1);
            }
        }
        return baos.toString(StandardCharsets.UTF_8);
    }

    protected String toFOP(String xmlFilename) throws FileNotFoundException, TransformerException {
        FileInputStream fis = new FileInputStream(xmlFilename);
        EStandard theStandard = this.findOutStandardFromRootNode(fis);
        fis = new FileInputStream(xmlFilename);
        return this.toFOP(fis, theStandard);
    }

    protected String toFOP(InputStream is, EStandard theStandard) throws FileNotFoundException, TransformerException {
        try {
            if (this.mXsltPDFTemplate == null) {
                this.mXsltPDFTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/xr-pdf.xsl")));
            }
        }
        catch (TransformerConfigurationException ex) {
            LOGGER.error("Failed to init XSLT templates", ex);
        }
        final ByteArrayOutputStream iaos = new ByteArrayOutputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (theStandard == EStandard.facturx) {
            this.applyZF2XSLT(is, iaos);
        } else if (theStandard == EStandard.ubl) {
            this.applyUBL2XSLT(is, iaos);
        } else if (theStandard == EStandard.ubl_creditnote) {
            this.applyUBLCreditNote2XSLT(is, iaos);
        }
        PipedInputStream in = new PipedInputStream();
        try {
            final PipedOutputStream out = new PipedOutputStream(in);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        iaos.writeTo(out);
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed to write to stream", e);
                    }
                    finally {
                        StreamHelper.close(out);
                    }
                }
            }).start();
            this.applyXSLTToPDF(in, baos);
        }
        catch (IOException e1) {
            LOGGER.error("Failed to create PDF", e1);
        }
        return baos.toString(StandardCharsets.UTF_8);
    }

    public void toPDF(String xmlFilename, String pdfFilename) {
        File XMLinputFile = new File(xmlFilename);
        String result = null;
        try {
            result = this.toFOP(XMLinputFile.getAbsolutePath());
        }
        catch (FileNotFoundException | TransformerException e) {
            LOGGER.error("Failed to apply FOP", e);
        }
        DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
        DefaultConfiguration cfg = null;
        try {
            cfg = cfgBuilder.build(CLASS_LOADER.getResourceAsStream("fop-config.xconf"));
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        FopFactoryBuilder builder = new FopFactoryBuilder(new File(".").toURI(), new ClasspathResolverURIAdapter()).setConfiguration(cfg);
        FopFactory fopFactory = builder.build();
        fopFactory.getFontManager().setResourceResolver(ResourceResolverFactory.createInternalResourceResolver(new File(".").toURI(), new ClasspathResolverURIAdapter()));
        FOUserAgent userAgent = fopFactory.newFOUserAgent();
        userAgent.getRendererOptions().put("pdf-a-mode", "PDF/A-3b");
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(pdfFilename));){
            Fop fop = fopFactory.newFop("application/pdf", userAgent, out);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            StreamSource src = new StreamSource(new ByteArrayInputStream(result.getBytes(StandardCharsets.UTF_8)));
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
        }
        catch (IOException | TransformerException | FOPException e) {
            LOGGER.error("Failed to create PDF", e);
        }
    }

    protected void applyZF2XSLT(InputStream xmlFile, OutputStream HTMLOutstream) throws TransformerException {
        if (this.mXsltXRTemplate == null) {
            this.mXsltXRTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/cii-xr.xsl")));
        }
        Transformer transformer = this.mXsltXRTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(HTMLOutstream));
    }

    protected void applyCIO2XSLT(InputStream xmlFile, OutputStream HTMLOutstream) throws TransformerException {
        if (this.mXsltCIOTemplate == null) {
            this.mXsltCIOTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/cio-xr.xsl")));
        }
        Transformer transformer = this.mXsltCIOTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(HTMLOutstream));
    }

    protected void applyUBL2XSLT(InputStream xmlFile, OutputStream HTMLOutstream) throws TransformerException {
        if (this.mXsltUBLTemplate == null) {
            this.mXsltUBLTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/ubl-invoice-xr.xsl")));
        }
        Transformer transformer = this.mXsltUBLTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(HTMLOutstream));
    }

    protected void applyUBLCreditNote2XSLT(InputStream xmlFile, OutputStream HTMLOutstream) throws TransformerException {
        if (this.mXsltUBLTemplate == null) {
            this.mXsltUBLTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/ubl-creditnote-xr.xsl")));
        }
        Transformer transformer = this.mXsltUBLTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(HTMLOutstream));
    }

    protected void applyZF1XSLT(InputStream xmlFile, OutputStream HTMLOutstream) throws TransformerException {
        Transformer transformer = this.mXsltZF1HTMLTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(HTMLOutstream));
    }

    protected void applyXSLTToHTML(InputStream xmlFile, OutputStream HTMLOutstream) throws TransformerException {
        Transformer transformer = this.mXsltHTMLTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(HTMLOutstream));
    }

    protected void applyXSLTToPDF(InputStream xmlFile, OutputStream PDFOutstream) throws TransformerException {
        Transformer transformer = this.mXsltPDFTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(PDFOutstream));
    }

    private static class ClasspathResourceURIResolver
    implements URIResolver {
        ClasspathResourceURIResolver() {
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            return new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/" + href));
        }
    }

    public static enum Language {
        EN,
        FR,
        DE;

    }
}

