/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeMap {
    private final Map<String, List<Node>> map = new HashMap<String, List<Node>>();

    public NodeMap(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        if (node.hasChildNodes()) {
            this.mapNodeList(node.getChildNodes());
        }
    }

    public NodeMap(NodeList nodeList) {
        if (nodeList == null) {
            throw new IllegalArgumentException("nodeList cannot be null");
        }
        this.mapNodeList(nodeList);
    }

    public Optional<Node> getNode(String ... localNames) {
        return this.getAllNodes(localNames).findAny();
    }

    public Optional<NodeMap> getAsNodeMap(String ... localNames) {
        return this.getNode(localNames).filter(Node::hasChildNodes).map(NodeMap::new);
    }

    public Optional<String> getAsString(String ... localNames) {
        return this.getNode(localNames).map(Node::getTextContent);
    }

    public Optional<BigDecimal> getAsBigDecimal(String ... localNames) {
        return this.getNode(localNames).map(Node::getTextContent).map(s -> new BigDecimal(s.trim()));
    }

    public String getAsStringOrNull(String ... localNames) {
        return this.getAsString(localNames).orElse(null);
    }

    public Stream<Node> getAllNodes(String ... localNames) {
        List<String> localNamesList = Arrays.asList(localNames);
        return this.map.entrySet().stream().filter(e -> localNamesList.contains(e.getKey())).flatMap(e -> ((List)e.getValue()).stream());
    }

    private void mapNodeList(NodeList nodeList) {
        IntStream.range(0, nodeList.getLength()).mapToObj(nodeList::item).filter(node -> node != null && node.getLocalName() != null).forEach(node -> this.map.computeIfAbsent(node.getLocalName(), k -> new ArrayList()).add(node));
    }

    public String toString() {
        return this.map.toString();
    }
}

