/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.validator;

import com.helger.schematron.ISchematronResource;
import com.helger.schematron.svrl.SVRLMarshaller;
import com.helger.schematron.svrl.jaxb.SchematronOutputType;
import com.helger.schematron.xslt.SchematronResourceXSLT;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Calendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.mustangproject.XMLTools;
import org.mustangproject.validator.EPart;
import org.mustangproject.validator.ESeverity;
import org.mustangproject.validator.IrrecoverableValidationError;
import org.mustangproject.validator.ValidationContext;
import org.mustangproject.validator.ValidationResultItem;
import org.mustangproject.validator.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLValidator
extends Validator {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLValidator.class.getCanonicalName());
    protected String zfXML = "";
    protected String filename = "";
    int firedRules = 0;
    int failedRules = 0;
    boolean disableNotices = false;
    ISchematronResource aResSCH = null;

    public XMLValidator(ValidationContext ctx) {
        super(ctx);
    }

    @Override
    public void setFilename(String name) throws IrrecoverableValidationError {
        this.filename = name;
        if (this.autoload) {
            try {
                this.zfXML = new String(XMLTools.removeBOM(Files.readAllBytes(Paths.get(this.filename, new String[0]))), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                ValidationResultItem vri = new ValidationResultItem(ESeverity.exception, e.getMessage()).setSection(9).setPart(EPart.fx);
                try (StringWriter sw = new StringWriter();
                     PrintWriter pw = new PrintWriter(sw);){
                    e.printStackTrace(pw);
                    vri.setStacktrace(sw.toString());
                    this.context.addResultItem(vri);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
        }
    }

    public void setStringContent(String xml) {
        this.zfXML = xml;
    }

    public static boolean matchesURI(String uri1, String uri2) {
        return uri1.equals(uri2) || uri1.startsWith(uri2 + "#");
    }

    public void disableNotices() {
        this.disableNotices = true;
    }

    @Override
    public void validate() throws IrrecoverableValidationError {
        long startXMLTime = Calendar.getInstance().getTimeInMillis();
        this.firedRules = 0;
        this.failedRules = 0;
        if (this.zfXML.isEmpty()) {
            ValidationResultItem res = new ValidationResultItem(ESeverity.exception, "XML data not found in " + this.filename + ": did you specify a pdf or xml file and does the xml file contain an embedded XML file?").setSection(3);
            this.context.addResultItem(res);
        } else {
            try {
                ESeverity XrechnungSeverity = ESeverity.notice;
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                InputSource is = new InputSource(new StringReader(this.zfXML));
                Document doc = db.parse(is);
                Element root = doc.getDocumentElement();
                XPathFactory xpathFactory = XPathFactory.newInstance();
                XPath xpath = xpathFactory.newXPath();
                XPathExpression expr = xpath.compile("(//*[local-name()=\"GuidelineSpecifiedDocumentContextParameter\"]/*[local-name()=\"ID\"])/text()|//*[local-name()=\"CustomizationID\"]/text()");
                NodeList ndList = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
                for (int bookingIndex = 0; bookingIndex < ndList.getLength(); ++bookingIndex) {
                    Node booking = ndList.item(bookingIndex);
                    this.context.setProfile(booking.getNodeValue());
                }
                boolean isOrderX = false;
                boolean isDespatchAdvice = false;
                boolean isMiniumum = false;
                boolean isBasic = false;
                boolean isBasicWithoutLines = false;
                boolean isEN16931 = false;
                boolean isExtended = false;
                boolean isXRechnung = false;
                String currentZFVersionDir = "ZF_232";
                int mainSchematronSectionErrorTypeCode = 4;
                Object xsltFilename = null;
                if (root.getLocalName().equalsIgnoreCase("SCRDMCCBDACIOMessageStructure")) {
                    this.context.setGeneration("1");
                    isOrderX = true;
                    isBasic = this.context.getProfile().contains("basic");
                    isEN16931 = this.context.getProfile().contains("comfort");
                    isExtended = this.context.getProfile().contains("extended");
                    this.validateSchema(this.zfXML.getBytes(StandardCharsets.UTF_8), "OX_10/comfort/SCRDMCCBDACIOMessageStructure_100pD20B.xsd", 99, EPart.ox);
                    xsltFilename = "/xslt/OX_10/comfort/SCRDMCCBDACIOMessageStructure_100pD20B_COMFORT.xslt";
                } else if (root.getLocalName().equalsIgnoreCase("SCRDMCCBDACIOMessageStructure")) {
                    this.context.setGeneration("1");
                    isOrderX = true;
                    this.validateSchema(this.zfXML.getBytes(StandardCharsets.UTF_8), "OX_10/comfort/SCRDMCCBDACIOMessageStructure_100pD20B.xsd", 99, EPart.ox);
                    xsltFilename = "/xslt/OX_10/comfort/SCRDMCCBDACIOMessageStructure_100pD20B_COMFORT.xslt";
                } else if (root.getLocalName().equalsIgnoreCase("CrossIndustryInvoice")) {
                    this.context.setGeneration("2");
                    isMiniumum = this.context.getProfile().contains("minimum");
                    isBasic = this.context.getProfile().contains("basic");
                    isBasicWithoutLines = this.context.getProfile().contains("basicwl");
                    if (isBasicWithoutLines) {
                        isBasic = false;
                    }
                    isEN16931 = XMLValidator.matchesURI(this.context.getProfile(), "urn:cen.eu:en16931:2017:compliant:factur-x.eu:1p0:en16931") || XMLValidator.matchesURI(this.context.getProfile(), "urn:cen.eu:en16931:2017");
                    isExtended = this.context.getProfile().contains("extended");
                    isXRechnung = this.context.getProfile().contains("xrechnung");
                    if (isExtended || isXRechnung) {
                        isEN16931 = false;
                    }
                    if (isMiniumum) {
                        LOGGER.debug("is Minimum");
                        this.validateSchema(this.zfXML.getBytes(StandardCharsets.UTF_8), currentZFVersionDir + "/MINIMUM/FACTUR-X_MINIMUM.xsd", 18, EPart.fx);
                        xsltFilename = "/xslt/" + currentZFVersionDir + "/FACTUR-X_MINIMUM.xslt";
                    } else if (isBasicWithoutLines) {
                        LOGGER.debug("is Basic/WL");
                        this.validateSchema(this.zfXML.getBytes(StandardCharsets.UTF_8), currentZFVersionDir + "/BASIC-WL/FACTUR-X_BASIC-WL.xsd", 18, EPart.fx);
                        xsltFilename = "/xslt/" + currentZFVersionDir + "/FACTUR-X_BASIC-WL.xslt";
                    } else if (isBasic) {
                        LOGGER.debug("is Basic");
                        this.validateSchema(this.zfXML.getBytes(StandardCharsets.UTF_8), currentZFVersionDir + "/BASIC/FACTUR-X_BASIC.xsd", 18, EPart.fx);
                        xsltFilename = "/xslt/" + currentZFVersionDir + "/FACTUR-X_BASIC.xslt";
                    } else if (isEN16931) {
                        LOGGER.debug("is EN16931");
                        this.validateSchema(this.zfXML.getBytes(StandardCharsets.UTF_8), currentZFVersionDir + "/EN16931/FACTUR-X_EN16931.xsd", 18, EPart.fx);
                        xsltFilename = "/xslt/" + currentZFVersionDir + "/FACTUR-X_EN16931.xslt";
                    } else if (isXRechnung) {
                        LOGGER.debug("is XRechnung");
                        this.validateSchema(this.zfXML.getBytes(StandardCharsets.UTF_8), currentZFVersionDir + "/EN16931/FACTUR-X_EN16931.xsd", 18, EPart.fx);
                        XrechnungSeverity = ESeverity.error;
                    } else if (isExtended) {
                        LOGGER.debug("is EXTENDED");
                        this.validateSchema(this.zfXML.getBytes(StandardCharsets.UTF_8), currentZFVersionDir + "/EXTENDED/FACTUR-X_EXTENDED.xsd", 18, EPart.fx);
                        xsltFilename = "/xslt/" + currentZFVersionDir + "/FACTUR-X_EXTENDED.xslt";
                    }
                } else if (root.getLocalName().equalsIgnoreCase("Invoice") || root.getLocalName().equalsIgnoreCase("CreditNote")) {
                    this.context.setGeneration("2");
                    this.context.setFormat("UBL");
                    isXRechnung = this.context.getProfile().contains("xrechnung");
                    LOGGER.debug("UBL");
                    this.validateSchema(this.zfXML.getBytes(StandardCharsets.UTF_8), "UBL_21/maindoc/UBL-" + root.getLocalName() + "-2.1.xsd", 18, EPart.fx);
                    xsltFilename = "/xslt/en16931schematron/EN16931-UBL-validation.xslt";
                    mainSchematronSectionErrorTypeCode = 24;
                    if (isXRechnung) {
                        this.validateSchematron(this.zfXML, (String)xsltFilename, 24, ESeverity.error);
                        String xrVersion = this.context.getProfile().substring(this.context.getProfile().length() - 3).replace(".", "");
                        if (!(xrVersion.equals("12") || xrVersion.equals("20") || xrVersion.equals("21") || xrVersion.equals("22") || xrVersion.equals("23") || xrVersion.equals("30"))) {
                            throw new Exception("Unsupported XR version");
                        }
                        LOGGER.debug("is XRechnung v" + xrVersion);
                        xsltFilename = "/xslt/XR_" + xrVersion + "/XRechnung-UBL-validation.xslt";
                        XrechnungSeverity = ESeverity.error;
                        mainSchematronSectionErrorTypeCode = 27;
                    }
                } else if (root.getLocalName().equalsIgnoreCase("CrossIndustryDocument")) {
                    this.context.setGeneration("1");
                    if (!(XMLValidator.matchesURI(this.context.getProfile(), "urn:ferd:CrossIndustryDocument:invoice:1p0:basic") || XMLValidator.matchesURI(this.context.getProfile(), "urn:ferd:CrossIndustryDocument:invoice:1p0:comfort") || XMLValidator.matchesURI(this.context.getProfile(), "urn:ferd:CrossIndustryDocument:invoice:1p0:extended"))) {
                        this.context.addResultItem(new ValidationResultItem(ESeverity.error, "Unsupported profile type").setSection(25).setPart(EPart.fx));
                    }
                    this.validateSchema(this.zfXML.getBytes(StandardCharsets.UTF_8), "ZF_10/ZUGFeRD1p0.xsd", 18, EPart.fx);
                    xsltFilename = "/xslt/ZUGFeRD_1p0.xslt";
                } else {
                    this.context.addResultItem(new ValidationResultItem(ESeverity.fatal, "Unsupported root element").setSection(3).setPart(EPart.fx));
                }
                if (this.context.getFormat().equals("CII")) {
                    if (this.context.getGeneration().equals("2")) {
                        if (!(XMLValidator.matchesURI(this.context.getProfile(), "urn:factur-x.eu:1p0:minimum") || XMLValidator.matchesURI(this.context.getProfile(), "urn:zugferd.de:2p0:minimum") || XMLValidator.matchesURI(this.context.getProfile(), "urn:factur-x.eu:1p0:basicwl") || XMLValidator.matchesURI(this.context.getProfile(), "urn:zugferd.de:2p0:basicwl") || XMLValidator.matchesURI(this.context.getProfile(), "urn:cen.eu:en16931:2017#compliant#urn:factur-x.eu:1p0:basic") || XMLValidator.matchesURI(this.context.getProfile(), "urn:cen.eu:en16931:2017#compliant#urn:zugferd.de:2p0:basic") || XMLValidator.matchesURI(this.context.getProfile(), "urn:cen.eu:en16931:2017") || XMLValidator.matchesURI(this.context.getProfile(), "urn:cen.eu:en16931:2017#conformant#urn:factur-x.eu:1p0:extended") || XMLValidator.matchesURI(this.context.getProfile(), "urn:cen.eu:en16931:2017#conformant#urn:zugferd.de:2p0:extended"))) {
                            this.context.addResultItem(new ValidationResultItem(ESeverity.error, "Unsupported profile type " + this.context.getProfile()).setSection(25).setPart(EPart.fx));
                        }
                    } else if (isOrderX) {
                        if (!(XMLValidator.matchesURI(this.context.getProfile(), "urn:order-x.eu:1p0:basic") || XMLValidator.matchesURI(this.context.getProfile(), "urn:order-x.eu:1p0:comfort") || XMLValidator.matchesURI(this.context.getProfile(), "urn:order-x.eu:1p0:extended"))) {
                            this.context.addResultItem(new ValidationResultItem(ESeverity.error, "Unsupported profile type").setSection(25).setPart(EPart.fx));
                        }
                    } else if (!(XMLValidator.matchesURI(this.context.getProfile(), "urn:ferd:CrossIndustryDocument:invoice:1p0:basic") || XMLValidator.matchesURI(this.context.getProfile(), "urn:ferd:CrossIndustryDocument:invoice:1p0:comfort") || XMLValidator.matchesURI(this.context.getProfile(), "urn:ferd:CrossIndustryDocument:invoice:1p0:extended"))) {
                        this.context.addResultItem(new ValidationResultItem(ESeverity.error, "Unsupported profile type").setSection(25).setPart(EPart.fx));
                    }
                }
                if (xsltFilename != null) {
                    this.validateSchematron(this.zfXML, (String)xsltFilename, mainSchematronSectionErrorTypeCode, ESeverity.error);
                }
                if (this.context.getFormat().equals("CII") && this.context.getGeneration().equals("2") && (isBasic || isEN16931 || isXRechnung)) {
                    this.validateSchematron(this.zfXML, "/xslt/en16931schematron/EN16931-CII-validation.xslt", 24, ESeverity.error);
                    if (!this.disableNotices || XrechnungSeverity != ESeverity.notice) {
                        this.validateXR(this.zfXML, XrechnungSeverity);
                    }
                }
            }
            catch (IrrecoverableValidationError er) {
                throw er;
            }
            catch (Exception e) {
                ValidationResultItem vri = new ValidationResultItem(ESeverity.exception, e.getMessage()).setSection(22).setPart(EPart.fx);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                vri.setStacktrace(sw.toString());
                this.context.addResultItem(vri);
            }
        }
        long endTime = Calendar.getInstance().getTimeInMillis();
        this.context.addCustomXML("<info><version>" + (this.context.getGeneration() != null ? this.context.getGeneration() : "invalid") + "</version><profile>" + (this.context.getProfile() != null ? this.context.getProfile() : "invalid") + "</profile><validator version=\"" + XMLValidator.class.getPackage().getImplementationVersion() + "\"></validator><rules><fired>" + this.firedRules + "</fired><failed>" + this.failedRules + "</failed></rules><duration unit=\"ms\">" + (endTime - startXMLTime) + "</duration></info>");
    }

    public void validateXR(String xml, ESeverity errorImpact) throws IrrecoverableValidationError {
        if (xml.contains(":xrechnung_1.")) {
            this.validateSchematron(xml, "/xslt/XR_12/XRechnung-CII-validation.xslt", 27, errorImpact);
        } else if (xml.contains(":xrechnung_2.0")) {
            this.validateSchematron(xml, "/xslt/XR_20/XRechnung-CII-validation.xslt", 27, errorImpact);
        } else if (xml.contains(":xrechnung_2.1")) {
            this.validateSchematron(xml, "/xslt/XR_21/XRechnung-CII-validation.xslt", 27, errorImpact);
        } else if (xml.contains(":xrechnung_2.2")) {
            this.validateSchematron(xml, "/xslt/XR_22/XRechnung-CII-validation.xslt", 27, errorImpact);
        } else if (xml.contains(":xrechnung_2.3")) {
            this.validateSchematron(xml, "/xslt/XR_23/XRechnung-CII-validation.xslt", 27, errorImpact);
        } else {
            this.validateSchematron(xml, "/xslt/XR_30/XRechnung-CII-validation.xslt", 27, errorImpact);
        }
    }

    public void validateSchematron(String xml, String xsltFilename, int section, ESeverity defaultSeverity) throws IrrecoverableValidationError {
        SchematronResourceXSLT aResSCH = null;
        ESeverity severity = defaultSeverity;
        if (defaultSeverity != ESeverity.notice) {
            severity = ESeverity.error;
        }
        if ((aResSCH = SchematronResourceXSLT.fromClassPath(xsltFilename)) != null) {
            SchematronOutputType sout;
            if (!aResSCH.isValidSchematron()) {
                throw new IllegalArgumentException(xsltFilename + " is invalid Schematron!");
            }
            try {
                sout = aResSCH.applySchematronValidationToSVRL(new StreamSource(new StringReader(xml)));
            }
            catch (Exception e) {
                throw new IrrecoverableValidationError(e.getMessage());
            }
            Document SVRLReport = new SVRLMarshaller().getAsDocument(sout);
            XPath xPath = XPathFactory.newInstance().newXPath();
            String expression = "//*[local-name() = 'failed-assert']";
            NodeList failedAsserts = null;
            try {
                failedAsserts = (NodeList)xPath.compile(expression).evaluate(SVRLReport, XPathConstants.NODESET);
                String thisFailText = "";
                Object thisFailID = "";
                String thisFailTest = "";
                String thisFailLocation = "";
                if (failedAsserts.getLength() > 0) {
                    for (int nodeIndex = 0; nodeIndex < failedAsserts.getLength(); ++nodeIndex) {
                        Node currentFailNode = failedAsserts.item(nodeIndex);
                        if (currentFailNode.getAttributes().getNamedItem("id") != null) {
                            thisFailID = " [ID " + currentFailNode.getAttributes().getNamedItem("id").getNodeValue() + "]";
                        }
                        if (currentFailNode.getAttributes().getNamedItem("test") != null) {
                            thisFailTest = currentFailNode.getAttributes().getNamedItem("test").getNodeValue();
                        }
                        if (currentFailNode.getAttributes().getNamedItem("location") != null) {
                            thisFailLocation = currentFailNode.getAttributes().getNamedItem("location").getNodeValue();
                        }
                        if (currentFailNode.getAttributes().getNamedItem("flag") != null && currentFailNode.getAttributes().getNamedItem("flag").getNodeValue().equals("warning") && defaultSeverity != ESeverity.notice) {
                            severity = ESeverity.warning;
                        }
                        NodeList failChilds = currentFailNode.getChildNodes();
                        for (int failChildIndex = 0; failChildIndex < failChilds.getLength(); ++failChildIndex) {
                            if (failChilds.item(failChildIndex).getLocalName() == null || !failChilds.item(failChildIndex).getLocalName().equals("text")) continue;
                            thisFailText = failChilds.item(failChildIndex).getTextContent();
                        }
                        LOGGER.info("FailedAssert ", (Object)thisFailText);
                        this.context.addResultItem(new ValidationResultItem(severity, thisFailText + (String)thisFailID + " from " + xsltFilename + ")").setLocation(thisFailLocation).setCriterion(thisFailTest).setSection(section).setPart(EPart.fx));
                        ++this.failedRules;
                    }
                }
            }
            catch (XPathExpressionException e) {
                LOGGER.error(e.getMessage(), e);
            }
            expression = "//*[local-name() = 'fired-rule']";
            NodeList firedAsserts = null;
            try {
                firedAsserts = (NodeList)xPath.compile(expression).evaluate(SVRLReport, XPathConstants.NODESET);
                this.firedRules = firedAsserts.getLength();
            }
            catch (XPathExpressionException e) {
                LOGGER.error(e.getMessage(), e);
            }
            if (this.firedRules == 0) {
                this.context.addResultItem(new ValidationResultItem(ESeverity.error, "No rules matched, XML to minimal?").setSection(26).setPart(EPart.fx));
            }
        }
    }

    public int getFiredRules() {
        return this.firedRules;
    }

    public int getFailedRules() {
        return this.failedRules;
    }
}

