/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.verapdf.core.Directory;

public class MapBackedDirectory<K, V>
implements Directory<K, V> {
    protected final Map<K, V> map;

    public MapBackedDirectory() {
        this(Collections.emptyMap());
    }

    public MapBackedDirectory(Map<K, V> map) {
        this.map = new HashMap<K, V>(map);
    }

    @Override
    public V getItem(K key) {
        return this.map.get(key);
    }

    @Override
    public List<V> getItems() {
        return Collections.unmodifiableList(new ArrayList<V>(this.map.values()));
    }

    @Override
    public Set<K> getKeys() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Directory)) {
            return false;
        }
        Directory other = (Directory)obj;
        if (!Objects.equals(this.getItems(), other.getItems())) {
            return false;
        }
        return Objects.equals(this.getKeys(), other.getKeys());
    }
}

