/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.core.utils;

public final class FileUtils {
    private static final String dot = ".";
    private static final String extensionRegEx = "\\.(?=[^\\.]+$)";

    public static String extFromFileName(String filename) {
        if (!filename.contains(dot)) {
            return "";
        }
        String[] nameParts = filename.split(extensionRegEx);
        if (nameParts.length > 0) {
            return nameParts[nameParts.length - 1];
        }
        return "";
    }

    public static boolean hasExtNoCase(String fileName, String ext) {
        return FileUtils.hasExt(fileName.toLowerCase(), ext.toLowerCase());
    }

    public static boolean hasExt(String fileName, String ext) {
        String fullExt = ext.startsWith(dot) ? ext : dot + ext;
        return fileName.endsWith(fullExt);
    }

    public static String addExt(String path, String ext) {
        int lastSep;
        int lastDot = path.lastIndexOf(dot);
        return lastDot > (lastSep = Math.max(path.lastIndexOf(92), path.lastIndexOf(47))) ? path.replaceAll(path.substring(lastDot + 1) + '$', ext) : path + dot + ext;
    }
}

