/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos.filters;

import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.verapdf.as.filters.io.ASBufferedInFilter;
import org.verapdf.as.io.ASInputStream;

public class COSFilterFlateDecode
extends ASBufferedInFilter {
    private final Inflater inflater = new Inflater();
    private int bufferSize;

    public COSFilterFlateDecode(ASInputStream stream) throws IOException {
        super(stream);
    }

    @Override
    public int read(byte[] buffer, int size) throws IOException {
        int bytesFed = 0;
        if (this.inflater.getRemaining() == 0) {
            bytesFed = this.feedBuffer(this.getBufferCapacity());
            if (bytesFed == -1) {
                return -1;
            }
            this.bufferSize = bytesFed;
            this.inflater.setInput(this.buffer, 0, this.bufferSize);
        }
        int startOffset = this.bufferSize - this.inflater.getRemaining();
        try {
            int res = this.inflater.inflate(buffer, 0, size);
            if (res == 0) {
                int added = this.addToBuffer(2048);
                if (added == -1) {
                    return -1;
                }
                this.bufferSize = bytesFed + added;
                this.inflater.setInput(this.buffer, 0, this.bufferSize);
                return this.inflater.inflate(buffer, 0, size);
            }
            return res;
        }
        catch (DataFormatException e) {
            try {
                return this.readByByte(buffer, startOffset, size);
            }
            catch (IOException exp) {
                throw new IOException("Can't decode Flate encoded data", e);
            }
        }
    }

    public int readByByte(byte[] buffer, int startOffset, int size) throws IOException {
        int readBytesAmount;
        this.inflater.reset();
        this.inflater.setInput(this.buffer, startOffset, this.bufferSize - startOffset);
        try {
            for (readBytesAmount = 0; readBytesAmount < size && this.inflater.inflate(buffer, readBytesAmount, 1) == 1; ++readBytesAmount) {
            }
        }
        catch (DataFormatException exp) {
            return readBytesAmount == 0 ? -1 : readBytesAmount;
        }
        throw new IOException();
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.inflater.reset();
    }
}

