/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos.filters;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.verapdf.as.filters.io.ASBufferedInFilter;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSKey;
import org.verapdf.tools.EncryptionToolsRevision4;
import org.verapdf.tools.RC4Encryption;

public class COSFilterRC4DecryptionDefault
extends ASBufferedInFilter {
    public static final int MAXIMAL_KEY_LENGTH = 16;
    private RC4Encryption rc4;

    public COSFilterRC4DecryptionDefault(ASInputStream stream, COSKey objectKey, byte[] encryptionKey) throws IOException, NoSuchAlgorithmException {
        super(stream);
        this.initRC4(objectKey, encryptionKey);
    }

    @Override
    public int read(byte[] buffer, int size) throws IOException {
        return this.read(buffer, 0, size);
    }

    @Override
    public int read(byte[] buffer, int off, int size) throws IOException {
        int bytesFed;
        if (this.bufferSize() == 0 && (bytesFed = this.feedBuffer(this.getBufferCapacity())) == -1) {
            return -1;
        }
        byte[] encData = new byte[2048];
        int encDataLength = this.bufferPopArray(encData, size);
        if (encDataLength >= 0) {
            byte[] res = this.rc4.process(encData, 0, encDataLength);
            System.arraycopy(res, 0, buffer, off, encDataLength);
        }
        return encDataLength;
    }

    @Override
    public void reset() throws IOException {
        this.rc4.reset();
        super.reset();
    }

    private void initRC4(COSKey objectKey, byte[] encryptionKey) throws NoSuchAlgorithmException {
        byte[] objectKeyDigest = COSFilterRC4DecryptionDefault.getObjectKeyDigest(objectKey);
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(ASBufferedInFilter.concatenate(encryptionKey, encryptionKey.length, objectKeyDigest, objectKeyDigest.length));
        byte[] resultEncryptionKey = md5.digest();
        int keyLength = Math.min(16, encryptionKey.length + objectKeyDigest.length);
        this.rc4 = new RC4Encryption(Arrays.copyOf(resultEncryptionKey, keyLength));
    }

    public static byte[] getObjectKeyDigest(COSKey objectKey) {
        byte[] res = new byte[5];
        System.arraycopy(EncryptionToolsRevision4.intToBytesLowOrderFirst(objectKey.getNumber()), 0, res, 0, 3);
        System.arraycopy(EncryptionToolsRevision4.intToBytesLowOrderFirst(objectKey.getGeneration()), 0, res, 3, 2);
        return res;
    }
}

