/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.features.FeaturesData;

public final class FontFeaturesData
extends FeaturesData {
    private static final Logger LOGGER = Logger.getLogger(FontFeaturesData.class.getCanonicalName());
    private final InputStream metadata;
    private final String fontName;
    private final String fontFamily;
    private final String fontStretch;
    private final Double fontWeight;
    private final Integer flags;
    private final List<Double> fontBBox;
    private final Double italicAngle;
    private final Double ascent;
    private final Double descent;
    private final Double leading;
    private final Double capHeight;
    private final Double xHeight;
    private final Double stemV;
    private final Double stemH;
    private final Double avgWidth;
    private final Double maxWidth;
    private final Double missingWidth;
    private final String charSet;

    FontFeaturesData(InputStream metadata, InputStream stream, String fontName, String fontFamily, String fontStretch, Double fontWeight, Integer flags, List<Double> fontBBox, Double italicAngle, Double ascent, Double descent, Double leading, Double capHeight, Double xHeight, Double stemV, Double stemH, Double avgWidth, Double maxWidth, Double missingWidth, String charSet) {
        super(stream);
        this.metadata = metadata;
        this.fontName = fontName;
        this.fontFamily = fontFamily;
        this.fontStretch = fontStretch;
        this.fontWeight = fontWeight;
        this.flags = flags;
        this.fontBBox = fontBBox == null ? null : new ArrayList<Double>(fontBBox);
        this.italicAngle = italicAngle;
        this.ascent = ascent;
        this.descent = descent;
        this.leading = leading;
        this.capHeight = capHeight;
        this.xHeight = xHeight;
        this.stemV = stemV;
        this.stemH = stemH;
        this.avgWidth = avgWidth;
        this.maxWidth = maxWidth;
        this.missingWidth = missingWidth;
        this.charSet = charSet;
    }

    public InputStream getMetadata() {
        return this.metadata;
    }

    public String getFontName() {
        return this.fontName;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public String getFontStretch() {
        return this.fontStretch;
    }

    public Double getFontWeight() {
        return this.fontWeight;
    }

    public Integer getFlags() {
        return this.flags;
    }

    public List<Double> getFontBBox() {
        return this.fontBBox == null ? null : Collections.unmodifiableList(this.fontBBox);
    }

    public Double getItalicAngle() {
        return this.italicAngle;
    }

    public Double getAscent() {
        return this.ascent;
    }

    public Double getDescent() {
        return this.descent;
    }

    public Double getLeading() {
        return this.leading;
    }

    public Double getCapHeight() {
        return this.capHeight;
    }

    public Double getXHeight() {
        return this.xHeight;
    }

    public Double getStemV() {
        return this.stemV;
    }

    public Double getStemH() {
        return this.stemH;
    }

    public Double getAvgWidth() {
        return this.avgWidth;
    }

    public Double getMaxWidth() {
        return this.maxWidth;
    }

    public Double getMissingWidth() {
        return this.missingWidth;
    }

    public String getCharSet() {
        return this.charSet;
    }

    @Override
    public void close() throws IOException {
        if (this.metadata != null) {
            try {
                this.metadata.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Exception during metadata closing", e);
            }
        }
        super.close();
    }

    public static final class Builder {
        private InputStream metadata = null;
        private InputStream stream;
        private String fontName = null;
        private String fontFamily = null;
        private String fontStretch = null;
        private Double fontWeight = null;
        private Integer flags = null;
        private List<Double> fontBBox = null;
        private Double italicAngle = null;
        private Double ascent = null;
        private Double descent = null;
        private Double leading = 0.0;
        private Double capHeight = null;
        private Double xHeight = 0.0;
        private Double stemV = null;
        private Double stemH = 0.0;
        private Double avgWidth = 0.0;
        private Double maxWidth = 0.0;
        private Double missingWidth = 0.0;
        private String charSet = null;

        public Builder(InputStream stream) {
            this.stream = stream;
        }

        public FontFeaturesData build() {
            if (this.stream == null) {
                throw new IllegalArgumentException("Font stream can not be null");
            }
            return new FontFeaturesData(this.metadata, this.stream, this.fontName, this.fontFamily, this.fontStretch, this.fontWeight, this.flags, this.fontBBox, this.italicAngle, this.ascent, this.descent, this.leading, this.capHeight, this.xHeight, this.stemV, this.stemH, this.avgWidth, this.maxWidth, this.missingWidth, this.charSet);
        }

        public Builder metadata(InputStream metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder stream(InputStream stream) {
            this.stream = stream;
            return this;
        }

        public Builder fontName(String fontName) {
            this.fontName = fontName;
            return this;
        }

        public Builder fontFamily(String fontFamily) {
            this.fontFamily = fontFamily;
            return this;
        }

        public Builder fontStretch(String fontStretch) {
            this.fontStretch = fontStretch;
            return this;
        }

        public Builder fontWeight(Double fontWeight) {
            this.fontWeight = fontWeight;
            return this;
        }

        public Builder flags(Integer flags) {
            this.flags = flags;
            return this;
        }

        public Builder fontBBox(List<Double> fontBBox) {
            this.fontBBox = fontBBox;
            return this;
        }

        public Builder italicAngle(Double italicAngle) {
            this.italicAngle = italicAngle;
            return this;
        }

        public Builder ascent(Double ascent) {
            this.ascent = ascent;
            return this;
        }

        public Builder descent(Double descent) {
            this.descent = descent;
            return this;
        }

        public Builder leading(Double leading) {
            this.leading = leading != null ? leading : Double.valueOf(0.0);
            return this;
        }

        public Builder capHeight(Double capHeight) {
            this.capHeight = capHeight;
            return this;
        }

        public Builder xHeight(Double xHeight) {
            this.xHeight = xHeight != null ? xHeight : Double.valueOf(0.0);
            return this;
        }

        public Builder stemV(Double stemV) {
            this.stemV = stemV;
            return this;
        }

        public Builder stemH(Double stemH) {
            this.stemH = stemH != null ? stemH : Double.valueOf(0.0);
            return this;
        }

        public Builder avgWidth(Double avgWidth) {
            this.avgWidth = avgWidth != null ? avgWidth : Double.valueOf(0.0);
            return this;
        }

        public Builder maxWidth(Double maxWidth) {
            this.maxWidth = maxWidth != null ? maxWidth : Double.valueOf(0.0);
            return this;
        }

        public Builder missingWidth(Double missingWidth) {
            this.missingWidth = missingWidth != null ? missingWidth : Double.valueOf(0.0);
            return this;
        }

        public Builder charSet(String charSet) {
            this.charSet = charSet;
            return this;
        }
    }
}

