/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.objects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.ImageFeaturesData;
import org.verapdf.features.objects.Feature;
import org.verapdf.features.objects.FeaturesObject;
import org.verapdf.features.objects.ImageXObjectFeaturesObjectAdapter;
import org.verapdf.features.tools.CreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class ImageXObjectFeaturesObject
extends FeaturesObject {
    private static final Logger LOGGER = Logger.getLogger(ImageXObjectFeaturesObject.class.getCanonicalName());
    private static final String X_OBJECT = "xobject";
    private static final String IMAGE = "image";
    private static final String X_OBJECT_XPATH = "xobject[@type='image']";
    private static final String ID = "id";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String BITS_PER_COMPONENT = "bitsPerComponent";
    private static final String INTERPOLATE = "interpolate";
    private static final String STRUCT_PARENT = "structParent";
    private static final String FILTERS = "filters";
    private static final String FILTER = "filter";

    public ImageXObjectFeaturesObject(ImageXObjectFeaturesObjectAdapter adapter) {
        super(adapter);
    }

    static List<Feature> getFeaturesList() {
        ArrayList<Feature> featuresList = new ArrayList<Feature>();
        featuresList.add(new Feature("Width", ImageXObjectFeaturesObject.generateVariableXPath(X_OBJECT_XPATH, WIDTH), Feature.FeatureType.NUMBER));
        featuresList.add(new Feature("Height", ImageXObjectFeaturesObject.generateVariableXPath(X_OBJECT_XPATH, HEIGHT), Feature.FeatureType.NUMBER));
        featuresList.add(new Feature("Bits Per Component", ImageXObjectFeaturesObject.generateVariableXPath(X_OBJECT_XPATH, BITS_PER_COMPONENT), Feature.FeatureType.NUMBER));
        featuresList.add(new Feature("Interpolate", ImageXObjectFeaturesObject.generateVariableXPath(X_OBJECT_XPATH, INTERPOLATE), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("Struct Parent", ImageXObjectFeaturesObject.generateVariableXPath(X_OBJECT_XPATH, STRUCT_PARENT), Feature.FeatureType.NUMBER));
        featuresList.add(new Feature("Filter", ImageXObjectFeaturesObject.generateVariableXPath(X_OBJECT_XPATH, FILTERS, FILTER), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Error IDs", ImageXObjectFeaturesObject.generateAttributeXPath(X_OBJECT_XPATH, "errorId"), Feature.FeatureType.STRING));
        return featuresList;
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.IMAGE_XOBJECT;
    }

    @Override
    protected FeatureTreeNode collectFeatures() throws FeatureParsingException {
        List<String> filtersList;
        Long struct;
        Long bitsPerComponent;
        String colorSpaceChild;
        Long height;
        Long width;
        ImageXObjectFeaturesObjectAdapter xImageAdapter = (ImageXObjectFeaturesObjectAdapter)this.adapter;
        FeatureTreeNode root = FeatureTreeNode.createRootNode(X_OBJECT);
        root.setAttribute("type", IMAGE);
        String id = xImageAdapter.getID();
        if (id != null) {
            root.setAttribute(ID, id);
        }
        if ((width = xImageAdapter.getWidth()) != null) {
            CreateNodeHelper.addNotEmptyNode(WIDTH, String.valueOf(width), root);
        }
        if ((height = xImageAdapter.getHeight()) != null) {
            CreateNodeHelper.addNotEmptyNode(HEIGHT, String.valueOf(height), root);
        }
        if ((colorSpaceChild = xImageAdapter.getColorSpaceChild()) != null) {
            FeatureTreeNode shading = root.addChild("colorSpace");
            shading.setAttribute(ID, colorSpaceChild);
        }
        if ((bitsPerComponent = xImageAdapter.getBitsPerComponent()) != null) {
            CreateNodeHelper.addNotEmptyNode(BITS_PER_COMPONENT, String.valueOf(bitsPerComponent), root);
        }
        root.addChild("imageMask").setValue(String.valueOf(xImageAdapter.getImageMask()));
        String maskChild = xImageAdapter.getMaskChild();
        if (maskChild != null) {
            FeatureTreeNode mask = root.addChild("mask");
            mask.setAttribute(ID, maskChild);
        }
        CreateNodeHelper.addNotEmptyNode(INTERPOLATE, String.valueOf(xImageAdapter.isInterpolate()), root);
        CreateNodeHelper.parseIDSet(xImageAdapter.getAlternatesChild(), "alternate", "alternates", root);
        String sMaskChild = xImageAdapter.getSMaskChild();
        if (sMaskChild != null) {
            FeatureTreeNode mask = root.addChild("sMask");
            mask.setAttribute(ID, sMaskChild);
        }
        if ((struct = xImageAdapter.getStructParent()) != null) {
            CreateNodeHelper.addNotEmptyNode(STRUCT_PARENT, String.valueOf(struct), root);
        }
        if (!(filtersList = xImageAdapter.getFilters()).isEmpty()) {
            FeatureTreeNode filters = root.addChild(FILTERS);
            for (String name : filtersList) {
                CreateNodeHelper.addNotEmptyNode(FILTER, name, filters);
            }
        }
        CreateNodeHelper.parseMetadata(xImageAdapter.getMetadata(), "metadata", root, this);
        return root;
    }

    @Override
    public FeaturesData getData() {
        ImageXObjectFeaturesObjectAdapter xImageAdapter = (ImageXObjectFeaturesObjectAdapter)this.adapter;
        ArrayList<ImageFeaturesData.Filter> resFilters = new ArrayList<ImageFeaturesData.Filter>();
        List<String> filterNames = xImageAdapter.getFilters();
        if (!filterNames.isEmpty()) {
            List<ImageXObjectFeaturesObjectAdapter.StreamFilterAdapter> filterAdapters = xImageAdapter.getFilterAdapters();
            block16: for (int i = 0; i < filterNames.size(); ++i) {
                String filterNameValue = filterNames.get(i);
                ImageXObjectFeaturesObjectAdapter.StreamFilterAdapter adapter = i < filterAdapters.size() ? filterAdapters.get(i) : null;
                switch (filterNameValue) {
                    case "LZWDecode": {
                        resFilters.add(ImageFeaturesData.Filter.newInstance(filterNameValue, ImageXObjectFeaturesObject.createLZWFilterMap(adapter), null));
                        continue block16;
                    }
                    case "FlateDecode": {
                        resFilters.add(ImageFeaturesData.Filter.newInstance(filterNameValue, ImageXObjectFeaturesObject.createFlatFilterMap(adapter), null));
                        continue block16;
                    }
                    case "CCITTFaxDecode": {
                        resFilters.add(ImageFeaturesData.Filter.newInstance(filterNameValue, ImageXObjectFeaturesObject.getCCITTFaxFiltersMap(adapter), null));
                        continue block16;
                    }
                    case "DCTDecode": {
                        resFilters.add(ImageFeaturesData.Filter.newInstance(filterNameValue, ImageXObjectFeaturesObject.getDCTFiltersMap(adapter), null));
                        continue block16;
                    }
                    case "JBIG2Decode": {
                        resFilters.add(ImageFeaturesData.Filter.newInstance(filterNameValue, new HashMap<String, String>(), adapter.getJBIG2Global()));
                        continue block16;
                    }
                    case "Crypt": {
                        if (adapter.hasCryptFilter()) {
                            LOGGER.log(Level.FINE, "An Image has a Crypt filter");
                            return null;
                        }
                    }
                    default: {
                        resFilters.add(ImageFeaturesData.Filter.newInstance(filterNameValue, new HashMap<String, String>(), null));
                    }
                }
            }
        }
        Integer width = ImageXObjectFeaturesObject.getIntegerWithDefault(xImageAdapter.getWidth(), null);
        Integer height = ImageXObjectFeaturesObject.getIntegerWithDefault(xImageAdapter.getHeight(), null);
        return ImageFeaturesData.newInstance(xImageAdapter.getMetadata(), xImageAdapter.getRawStreamData(), width, height, resFilters);
    }

    private static Map<String, String> getCCITTFaxFiltersMap(ImageXObjectFeaturesObjectAdapter.StreamFilterAdapter filter) {
        HashMap<String, String> res = new HashMap<String, String>();
        if (filter != null) {
            ImageXObjectFeaturesObject.putIntegerAsStringWithDefault(res, "K", filter.getCCITTK(), 0);
            ImageXObjectFeaturesObject.putBooleanAsStringWithDefault(res, "EndOfLine", filter.getCCITTEndOfLine(), Boolean.FALSE);
            ImageXObjectFeaturesObject.putBooleanAsStringWithDefault(res, "EncodedByteAlign", filter.getCCITTEncodedByteAlign(), Boolean.FALSE);
            ImageXObjectFeaturesObject.putIntegerAsStringWithDefault(res, "Columns", filter.getCCITTColumns(), 1728);
            ImageXObjectFeaturesObject.putIntegerAsStringWithDefault(res, "Rows", filter.getCCITTRows(), 0);
            ImageXObjectFeaturesObject.putBooleanAsStringWithDefault(res, "EndOfBlock", filter.getCCITTEndOfBlock(), Boolean.TRUE);
            ImageXObjectFeaturesObject.putBooleanAsStringWithDefault(res, "BlackIs1", filter.getCCITTBlackIs1(), Boolean.FALSE);
            ImageXObjectFeaturesObject.putIntegerAsStringWithDefault(res, "DamagedRowsBeforeError", filter.getCCITTDamagedRowsBeforeError(), 0);
        } else {
            res.put("K", "0");
            res.put("EndOfLine", "false");
            res.put("EncodedByteAlign", "false");
            res.put("Columns", "1728");
            res.put("Rows", "0");
            res.put("EndOfBlock", "true");
            res.put("BlackIs1", "false");
            res.put("DamagedRowsBeforeError", "0");
        }
        return res;
    }

    private static Map<String, String> getDCTFiltersMap(ImageXObjectFeaturesObjectAdapter.StreamFilterAdapter filter) {
        Long colorTransform;
        HashMap<String, String> res = new HashMap<String, String>();
        if (filter != null && (colorTransform = filter.getDCTColorTransform()) != null) {
            res.put("ColorTransform", String.valueOf(colorTransform));
        }
        return res;
    }

    private static Map<String, String> createLZWFilterMap(ImageXObjectFeaturesObjectAdapter.StreamFilterAdapter filter) {
        if (filter == null) {
            Map<String, String> retVal = ImageXObjectFeaturesObject.createDefaultFlatFilterMap();
            retVal.put("EarlyChange", "1");
            return retVal;
        }
        Map<String, String> retVal = ImageXObjectFeaturesObject.createFlatFilterMap(filter);
        ImageXObjectFeaturesObject.putIntegerAsStringWithDefault(retVal, "EarlyChange", filter.getLZWEarlyChange(), 1);
        return retVal;
    }

    private static Map<String, String> createFlatFilterMap(ImageXObjectFeaturesObjectAdapter.StreamFilterAdapter filter) {
        if (filter == null) {
            return ImageXObjectFeaturesObject.createDefaultFlatFilterMap();
        }
        HashMap<String, String> res = new HashMap<String, String>();
        ImageXObjectFeaturesObject.putIntegerAsStringWithDefault(res, "Predictor", filter.getFlatePredictor(), 1);
        ImageXObjectFeaturesObject.putIntegerAsStringWithDefault(res, "Colors", filter.getFlateColors(), 1);
        ImageXObjectFeaturesObject.putIntegerAsStringWithDefault(res, "BitsPerComponent", filter.getFlateBitsPerComponent(), 8);
        ImageXObjectFeaturesObject.putIntegerAsStringWithDefault(res, "Columns", filter.getFlateColumns(), 1);
        return res;
    }

    private static Map<String, String> createDefaultFlatFilterMap() {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("Predictor", "1");
        res.put("Colors", "1");
        res.put("BitsPerComponent", "8");
        res.put("Columns", "1");
        return res;
    }

    private static Integer getIntegerWithDefault(Long value, Integer defaultValue) {
        if (value != null) {
            return value.intValue();
        }
        return defaultValue;
    }

    private static void putIntegerAsStringWithDefault(Map<String, String> map, String key, Long value, Integer defaultValue) {
        if (value != null) {
            map.put(key, String.valueOf(value));
        } else if (defaultValue != null) {
            map.put(key, defaultValue.toString());
        }
    }

    private static void putBooleanAsStringWithDefault(Map<String, String> map, String key, Boolean value, Boolean defaultValue) {
        if (value != null) {
            map.put(key, String.valueOf(value));
        } else if (defaultValue != null) {
            map.put(key, defaultValue.toString());
        }
    }
}

