/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.objects;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.objects.Feature;
import org.verapdf.features.objects.FeaturesObject;
import org.verapdf.features.objects.OutlinesFeaturesObjectAdapter;
import org.verapdf.features.tools.ColorComponent;
import org.verapdf.features.tools.CreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class OutlinesFeaturesObject
extends FeaturesObject {
    private static final String OUTLINES = "outlines";

    public OutlinesFeaturesObject(OutlinesFeaturesObjectAdapter adapter) {
        super(adapter);
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.OUTLINES;
    }

    @Override
    public FeatureTreeNode collectFeatures() throws FeatureParsingException {
        OutlinesFeaturesObjectAdapter outlinesAdapter = (OutlinesFeaturesObjectAdapter)this.adapter;
        FeatureTreeNode root = FeatureTreeNode.createRootNode(OUTLINES);
        HashSet<Integer> itemsNumbers = new HashSet<Integer>();
        for (OutlinesFeaturesObjectAdapter.OutlineFeaturesObjectAdapter item : outlinesAdapter.getChildren()) {
            Integer keyNumber = item.getKeyNumber();
            if (keyNumber == null || itemsNumbers.contains(keyNumber)) continue;
            itemsNumbers.add(keyNumber);
            this.createItem(item, root, itemsNumbers);
        }
        return root;
    }

    private void createItem(OutlinesFeaturesObjectAdapter.OutlineFeaturesObjectAdapter item, FeatureTreeNode root, Set<Integer> items) throws FeatureParsingException {
        FeatureTreeNode itemNode = root.addChild("outline");
        CreateNodeHelper.addNotEmptyNode("title", item.getTitle(), itemNode);
        FeatureTreeNode color = itemNode.addChild("color");
        double[] clr = item.getColor();
        if (clr != null) {
            color.setAttributes(ColorComponent.RGB_COMPONENTS.createAttributesMap(clr));
        } else {
            this.registerNewError("Color must be in rgb form");
        }
        FeatureTreeNode style = itemNode.addChild("style");
        style.setAttribute("italic", String.valueOf(item.isItalic()));
        style.setAttribute("bold", String.valueOf(item.isBold()));
        for (OutlinesFeaturesObjectAdapter.OutlineFeaturesObjectAdapter child : item.getChildren()) {
            Integer keyNumber = child.getKeyNumber();
            if (keyNumber == null || items.contains(keyNumber)) continue;
            this.createItem(child, itemNode, items);
        }
    }

    @Override
    public FeaturesData getData() {
        return null;
    }

    static List<Feature> getFeaturesList() {
        ArrayList<Feature> featuresList = new ArrayList<Feature>();
        featuresList.add(new Feature("Error IDs", OutlinesFeaturesObject.generateAttributeXPath(OUTLINES, "errorId"), Feature.FeatureType.STRING));
        return featuresList;
    }
}

