/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.external;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.external.GFExternal;
import org.verapdf.model.external.PKCSDataObject;
import org.verapdf.pdfa.parsers.pkcs7.PKCS7;
import org.verapdf.pdfa.parsers.pkcs7.X509CertificateImpl;

public class GFPKCSDataObject
extends GFExternal
implements PKCSDataObject {
    private static final Logger LOGGER = Logger.getLogger(GFPKCSDataObject.class.getCanonicalName());
    public static final String PKCS_DATA_OBJECT_TYPE = "PKCSDataObject";
    private PKCS7 pkcs7;

    public GFPKCSDataObject(COSString pkcsData) {
        super(PKCS_DATA_OBJECT_TYPE);
        try {
            this.pkcs7 = new PKCS7(pkcsData.get());
        }
        catch (IOException | ArrayIndexOutOfBoundsException e) {
            LOGGER.log(Level.FINE, "Passed PKCS7 object can't be read", e);
            this.pkcs7 = GFPKCSDataObject.getEmptyPKCS7();
        }
    }

    @Override
    public Long getSignerInfoCount() {
        return this.pkcs7.getSignerInfosLength();
    }

    @Override
    public Boolean getsigningCertificatePresent() {
        List<X509CertificateImpl> certificates = this.pkcs7.getCertificates();
        if (certificates.isEmpty()) {
            return Boolean.FALSE;
        }
        for (X509CertificateImpl cert : certificates) {
            if (cert != null) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static PKCS7 getEmptyPKCS7() {
        return new PKCS7(new ArrayList<X509CertificateImpl>());
    }
}

