/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.PDAppearanceStream;
import org.verapdf.pd.PDObject;

public class PDAppearanceEntry
extends PDObject {
    public PDAppearanceEntry(COSObject obj) {
        super(obj);
    }

    public boolean isSubDictionary() {
        return this.getObject().getType() == COSObjType.COS_DICT;
    }

    public Map<ASAtom, PDAppearanceStream> getSubDictionary() {
        if (!this.isSubDictionary()) {
            throw new IllegalStateException("Current appearance entry is a stream");
        }
        HashMap<ASAtom, PDAppearanceStream> res = new HashMap<ASAtom, PDAppearanceStream>();
        for (ASAtom key : this.getObject().getKeySet()) {
            COSObject obj = this.getKey(key);
            if (obj.isIndirect().booleanValue()) {
                obj = obj.getDirect();
            }
            if (obj == null || obj.getType() != COSObjType.COS_STREAM) continue;
            res.put(key, new PDAppearanceStream(obj));
        }
        return Collections.unmodifiableMap(res);
    }

    public PDAppearanceStream getAppearanceStream() {
        if (this.isSubDictionary()) {
            throw new IllegalStateException("Current appearance entry is not a stream");
        }
        return new PDAppearanceStream(this.getObject());
    }
}

