/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.truetype;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.io.SeekableInputStream;

public class AdobeGlyphList {
    private static final Logger LOGGER = Logger.getLogger(AdobeGlyphList.class.getCanonicalName());
    private static final Map<String, AGLUnicode> MAPPING = new HashMap<String, AGLUnicode>();
    private static final String AGL_FILE = "/font/AdobeGlyphList.txt";
    private static final AGLUnicode EMPTY = new AGLUnicode(-1);

    public static AGLUnicode get(String glyphName) {
        AGLUnicode res = MAPPING.get(glyphName);
        if (res == null) {
            LOGGER.log(Level.FINE, "Cannot find glyph " + glyphName + " in Adobe Glyph List");
            return EMPTY;
        }
        return res;
    }

    public static boolean contains(String glyphName) {
        return MAPPING.containsKey(glyphName);
    }

    public static AGLUnicode empty() {
        return EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            Scanner scanner;
            File aglFile = new File(AdobeGlyphList.class.getResource(AGL_FILE).getFile());
            if (aglFile.exists()) {
                scanner = new Scanner(aglFile, "ISO-8859-1");
            } else {
                try (InputStream input = AdobeGlyphList.class.getResourceAsStream(AGL_FILE);){
                    scanner = new Scanner((InputStream)SeekableInputStream.getSeekableStream(input), "ISO-8859-1");
                }
            }
            try {
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    String[] words = line.split(" ");
                    int symbolCode = Integer.parseInt(words[1], 16);
                    if (words.length == 2) {
                        MAPPING.put(words[0], new AGLUnicode(symbolCode));
                        continue;
                    }
                    int[] diacritic = new int[words.length - 2];
                    for (int i = 0; i < diacritic.length; ++i) {
                        diacritic[i] = Integer.parseInt(words[i + 2], 16);
                    }
                    MAPPING.put(words[0], new AGLUnicode(symbolCode, diacritic));
                }
            }
            finally {
                scanner.close();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Error in opening Adobe Glyph List file", e);
        }
    }

    public static class AGLUnicode {
        private final int symbolCode;
        private final int[] diacriticCodes;

        AGLUnicode(int symbolCode, int ... diacriticCode) {
            this.symbolCode = symbolCode;
            this.diacriticCodes = diacriticCode;
        }

        AGLUnicode(int symbolCode) {
            this.symbolCode = symbolCode;
            this.diacriticCodes = new int[0];
        }

        public int getSymbolCode() {
            return this.symbolCode;
        }

        public int[] getDiacriticCodes() {
            return this.diacriticCodes;
        }

        public boolean hasDiacritic() {
            return this.diacriticCodes.length != 0;
        }

        public String getUnicodeString() {
            int[] res = new int[this.diacriticCodes.length + 1];
            res[0] = this.symbolCode;
            System.arraycopy(this.diacriticCodes, 0, res, 1, this.diacriticCodes.length);
            return new String(res, 0, res.length);
        }
    }
}

