/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation.profiles;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.verapdf.pdfa.validation.profiles.ErrorDetails;
import org.verapdf.pdfa.validation.profiles.ErrorDetailsImpl;
import org.verapdf.pdfa.validation.profiles.Reference;
import org.verapdf.pdfa.validation.profiles.Rule;
import org.verapdf.pdfa.validation.profiles.RuleId;
import org.verapdf.pdfa.validation.profiles.RuleIdImpl;

@XmlRootElement(name="rule")
final class RuleImpl
implements Rule {
    private static final RuleImpl DEFAULT = new RuleImpl();
    @XmlElement
    private final RuleId id;
    @XmlAttribute
    private final String object;
    @XmlAttribute
    private final Boolean deferred;
    @XmlAttribute
    private final String tags;
    @XmlElement
    private final String description;
    @XmlElement
    private final String test;
    @XmlElement
    private final ErrorDetails error;
    @XmlElementWrapper
    @XmlElement(name="reference")
    private final List<Reference> references = new ArrayList<Reference>();

    private RuleImpl() {
        this(RuleIdImpl.defaultInstance(), "object", null, null, "description", "test", ErrorDetailsImpl.defaultInstance(), Collections.emptyList());
    }

    private RuleImpl(RuleId id, String object, Boolean deferred, String tags, String description, String test, ErrorDetails error, List<Reference> references) {
        this.id = id;
        this.object = object;
        this.deferred = deferred;
        this.tags = tags;
        this.description = description;
        this.test = test;
        this.error = error;
        this.references.addAll(references);
    }

    @Override
    public RuleId getRuleId() {
        return this.id;
    }

    @Override
    public String getObject() {
        return this.object;
    }

    @Override
    public Boolean getDeferred() {
        return this.deferred;
    }

    @Override
    public String getTags() {
        return this.tags;
    }

    @Override
    public Set<String> getTagsSet() {
        return this.tags != null ? new LinkedHashSet<String>(Arrays.asList(this.tags.split(","))) : Collections.emptySet();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getTest() {
        return this.test;
    }

    @Override
    public ErrorDetails getError() {
        return this.error;
    }

    @Override
    public List<Reference> getReferences() {
        return Collections.unmodifiableList(this.references);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RuleImpl)) {
            return false;
        }
        RuleImpl rule = (RuleImpl)o;
        if (!Objects.equals(this.id, rule.id)) {
            return false;
        }
        if (!Objects.equals(this.object, rule.object)) {
            return false;
        }
        if (!Objects.equals(this.deferred, rule.deferred)) {
            return false;
        }
        if (!Objects.equals(this.tags, rule.tags)) {
            return false;
        }
        if (!Objects.equals(this.description, rule.description)) {
            return false;
        }
        if (!Objects.equals(this.test, rule.test)) {
            return false;
        }
        if (!Objects.equals(this.error, rule.error)) {
            return false;
        }
        return Objects.equals(this.references, rule.references);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.object != null ? this.object.hashCode() : 0);
        result = 31 * result + (this.deferred != null ? this.deferred.hashCode() : 0);
        result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.test != null ? this.test.hashCode() : 0);
        result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
        result = 31 * result + (this.references != null ? this.references.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Rule [id=" + this.id + ", object=" + this.object + ", deferred=" + this.deferred + ", tags=" + this.tags + ", description=" + this.description + ", test=" + this.test + ", error=" + this.error + ", references=" + this.references + "]";
    }

    static RuleImpl defaultInstance() {
        return DEFAULT;
    }

    static RuleImpl fromValues(RuleId id, String object, Boolean deferred, String tags, String description, String test, ErrorDetails error, List<Reference> references) {
        return new RuleImpl(RuleIdImpl.fromRuleId(id), object, deferred, tags, description, test, error, references);
    }

    static RuleImpl fromRule(Rule toConvert) {
        return RuleImpl.fromValues(RuleIdImpl.fromRuleId(toConvert.getRuleId()), toConvert.getObject(), toConvert.getDeferred(), toConvert.getTags(), toConvert.getDescription(), toConvert.getTest(), toConvert.getError(), toConvert.getReferences());
    }

    public static String getStringWithoutProfilesTabulation(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        return string.replaceAll("[\\s\u00a0\u2007\u202f]+", " ");
    }

    static class Adapter
    extends XmlAdapter<RuleImpl, Rule> {
        Adapter() {
        }

        @Override
        public Rule unmarshal(RuleImpl ruleImpl) {
            return new RuleImpl(ruleImpl.getRuleId(), ruleImpl.getObject(), ruleImpl.getDeferred(), ruleImpl.getTags(), RuleImpl.getStringWithoutProfilesTabulation(ruleImpl.getDescription()), RuleImpl.getStringWithoutProfilesTabulation(ruleImpl.getTest()), ruleImpl.getError(), ruleImpl.getReferences());
        }

        @Override
        public RuleImpl marshal(Rule rule) {
            return (RuleImpl)rule;
        }
    }
}

