/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.tools;

import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.font.cmap.CMap;

public class FontProgramIDGenerator {
    private static final String NULL = "null";

    private FontProgramIDGenerator() {
    }

    public static String getCIDFontType2ProgramID(COSKey key, CMap cMap, COSObject cidToGIDMap) {
        return FontProgramIDGenerator.getBaseFontProgramID("CIDFontType2Program", key, cMap) + ' ' + FontProgramIDGenerator.getCOSObjectID(cidToGIDMap);
    }

    public static String getCFFFontProgramID(COSKey key, CMap cMap, boolean isSubset) {
        return FontProgramIDGenerator.getBaseFontProgramID("CFFFontProgram", key, cMap) + ' ' + isSubset;
    }

    public static String getOpenTypeFontProgramID(COSKey key, boolean isCFF, boolean isSymbolic, COSObject encoding, CMap cMap, boolean isSubset) {
        return FontProgramIDGenerator.getBaseFontProgramID("OpenTypeFontProgram", key, cMap) + ' ' + isCFF + ' ' + isSymbolic + ' ' + FontProgramIDGenerator.getCOSObjectID(encoding) + ' ' + isSubset;
    }

    public static String getTrueTypeFontProgramID(COSKey key, boolean isSymbolic, COSObject encoding) {
        if (key == null) {
            return null;
        }
        return "TrueTypeFontProgram " + key + ' ' + isSymbolic + ' ' + FontProgramIDGenerator.getCOSObjectID(encoding);
    }

    public static String getType1FontProgramID(COSKey key) {
        if (key == null) {
            return null;
        }
        return "Type1FontProgram " + key;
    }

    private static String getBaseFontProgramID(String type, COSKey key, CMap cMap) {
        if (key == null) {
            return null;
        }
        return type + ' ' + key + ' ' + FontProgramIDGenerator.getObjectID(cMap);
    }

    private static String getCOSObjectID(COSObject cosObject) {
        if (cosObject != null) {
            COSKey mapObjectKey = cosObject.getObjectKey();
            if (mapObjectKey != null) {
                return mapObjectKey.toString();
            }
            return "direct";
        }
        return NULL;
    }

    private static String getObjectID(Object obj) {
        return obj == null ? NULL : String.valueOf(obj.hashCode());
    }
}

